% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naming.R
\name{naming}
\alias{naming}
\title{Name an operation}
\usage{
naming(
  start = NULL,
  sets1,
  middle = NULL,
  sets2 = NULL,
  collapse_symbol = "union"
)
}
\arguments{
\item{start, middle}{Character used as a start symbol or to divide
\code{sets1} and \code{sets2}.}

\item{sets1, sets2}{Character of sets}

\item{collapse_symbol}{Name of the symbol that joins the sets on
\code{sets1} and \code{sets2}.}
}
\value{
A character vector combining the sets
}
\description{
Helps setting up the name of an operation.
}
\examples{
naming(sets1 = c("a", "b"))
naming(sets1 = "a", middle = "union", sets2 = "b")
naming(sets1 = "a", middle = "intersection", sets2 = c("b", "c"))
naming(sets1 = "a", middle = "intersection", sets2 = c("b", "c"))
naming(
    start = "complement", sets1 = "a", middle = "intersection",
    sets2 = c("b", "c"), collapse_symbol = "intersection"
)
}
\seealso{
\code{\link{set_symbols}}
}
