% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assistnet.R
\name{assistnet}
\alias{assistnet}
\title{Investigates the network of assists-shots in a team}
\usage{
assistnet(
  data,
  assist = "assist",
  player = "player",
  points = "points",
  event.type = "event_type"
)
}
\arguments{
\item{data}{a data frame whose rows are field shots and columns are variables to be specified in \code{assist}, \code{player}, \code{points}, \code{event.type} (see Details).}

\item{assist}{character, indicating the name of the variable with players who made the assists, if any.}

\item{player}{character, indicating the name of the variable with players who made the shot.}

\item{points}{character, indicating the name of the variable with points.}

\item{event.type}{character, indicating the name of the variable with type of event (mandatory categories are \code{"miss"} for missed field shots and \code{"shot"} for field goals).}
}
\value{
A \code{list} with 3 elements, \code{assistTable} (a table), \code{nodeStats} (a data frame), and \code{assistNet} (a network object). See Details.

\code{assistTable}, the cross-table of assists made and received by the players.

\code{nodeStats}, a data frame with the following variables:

\itemize{
\item \code{FGM} (fields goals made),
}

\itemize{
\item \code{FGM_AST} (field goals made thanks to a teammate's assist),
}

\itemize{
\item \code{FGM_ASTp} (percentage of \code{FGM_AST} over \code{FGM}),
}

\itemize{
\item \code{FGPTS} (points scored with field goals),
}

\itemize{
\item \code{FGPTS_AST} (points scored thanks to a teammate's assist),
}

\itemize{
\item \code{FGPTS_ASTp} (percentage of \code{FGPTS_AST} over \code{FGPTS}),
}

\itemize{
\item \code{AST} (assists made),
}

\itemize{
\item \code{ASTPTS} (point scored by assist's teammates).
}

\code{assistNet}, an object of class \code{network} that can be used for further network analysis with specific R packages (see \code{\link[network]{network}})
}
\description{
Investigates the network of assists-shots in a team
}
\details{
The \code{data} data frame could also be a play-by-play dataset provided that rows corresponding to events different from field shots are not coded as \code{"shot"} in the \code{event.type} variable.
}
\examples{
PbP <- PbPmanipulation(PbP.BDB)
PbP.GSW <- subset(PbP, team=="GSW")
out <- assistnet(PbP.GSW)
plot(out, layout="circle", edge.thr=30, node.col="FGM_ASTp", node.size="ASTPTS")
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
