% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP2D.R
\name{BP2D}
\alias{BP2D}
\title{Bayesian estimation using two dimensions Bernstein polynomial}
\usage{
BP2D(prior, input_data = input_data, ages = ages, years = years,
  Iterations = 2e+05, n_cluster = 1, n_chain = 5, RJC = 0.35,
  nn = 2, seed = TRUE, set = 1, interval = 100, double = 4)
}
\arguments{
\item{prior}{prior=(n0,alpha,L) where alpha is a Poisson parameter,n0 is upper bound of alpha
L can be every number which is bigger than one.}

\item{input_data}{It contain disease and population(ex: simulated_data_1).}

\item{ages}{Range of ages.}

\item{years}{Range of years.}

\item{Iterations}{Iterations of chain.}

\item{n_cluster}{This parameter means number of cores, five cores is recommended.(default: n_cluster=1).}

\item{n_chain}{Number of Markov chain.}

\item{RJC}{Control parameter for transfer dimension.}

\item{nn}{The parameter nn is lower bound of alpha.}

\item{seed}{Set seed yes or not.}

\item{set}{Choose seed.(defaults:set=1)}

\item{interval}{Each hundreds save one coefficient.}

\item{double}{If R.hat >1.1 then double the iterations of times.}
}
\value{
This function will return Bayesian estimate of incidence,Stored parameters,posterior mean,posterior max and table.
\item{Fhat}{Bayesian estimate of incidence.}
\item{chain}{Bayesian estimate of posterior p-value mean.}
\item{maxchain}{Bayesian estimate of posterior p-value max.}
\item{store_coefficients}{Two dimensional Bernstein coefficients.}
\item{output}{When M-H algorithm ends,contruct the table which contains norm,mean of Fhat,maximum of Fhat,R.hat,iterations,P-value and elasped time.}
}
\description{
This function runs Metropolis-Hasting algorithm which is given setting prior and data.This algorithm starts storing coefficients when it runs halfway,so we use second halves of coefficients compute Rhat to check convergence.
}
\examples{
\donttest{
library(BayesBP)
#simulated_data_1,simulated_data_2
#Ages 1~85,years 1988~2007
#Data are zero from 0 to 34
#Given one prior and simulated_data_1
data('simulated_data_1')
ages<-35:85
years<-1988:2007
prior<-c(10,5,2)
result<-BP2D(prior,simulated_data_1,ages,years,n_cluster=1)
result$Fhat
result$chain
result$maxchain
result$output
result$store_coefficients$chain_1
matplot(result$chain,type='l',main='Posterior mean trace plot')
matplot(result$maxchain,type='l',main='Posterior max trace plot')
BP2D_coef(result)
write.BP(result,filename = 'result.xlsx')
write.BP('result',filename = 'result.xlsx')

#Given four prior and simulated_data_2
data('simulated_data_2')
n0<-c(10,20,10,20)
alpha<-c(5,10,5,10)
L<-c(2,2,4,4)
prior<-cbind(n0,alpha,L)
ages<-35:85
years<-1988:2007
results_list<-paste0('result_',letters[1:4])
for(i in 1:4){
 assign(results_list[i],BP2D(prior[i,],simulated_data_2,ages,years,n_cluster=1))
}
BPtable<-BP2D_table(results_list)
write.BPtable(BPtable,filename = 'BPtable.xlsx')
mapply(write.BP,results_list,paste0(results_list,'.xlsx'))
#Credible interval
CI<-Credible_interval(result,n_cluster = 1)
CI_pda<-Credible_interval_pd_ages(result,n_cluster = 1)
CI_pdy<-Credible_interval_pd_years(result,n_cluster = 1)
CI
CI_pda
CI_pdy
}
}
\references{
Li-Chu Chien,Yuh-Jenn Wu,Chao A. Hsiung,Lu-Hai Wang,I-Shou Chang(2015).Smoothed Lexis Diagrams With Applications to Lung and Breast Cancer Trends in Taiwan,Journal of the American Statistical Association, Taylor & Francis Journals, vol. 110(511), pages 1000-1012, September.
}
\seealso{
Other Bayesain estimate: \code{\link{BP2D_coef}},
  \code{\link{BP2D_table}}
}
\concept{Bayesain estimate}
