% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_posterior_intervals.R
\name{compute_posterior_intervals}
\alias{compute_posterior_intervals}
\title{Compute Posterior Intervals}
\usage{
compute_posterior_intervals(model_fit, burnin = model_fit$burnin,
  parameter = "alpha", level = 0.95, decimals = 3L)
}
\arguments{
\item{model_fit}{An object returned from \code{\link{compute_mallows}}.}

\item{burnin}{A numeric value specifying the number of iterations
to discard as burn-in. Defaults to \code{model_fit$burnin}, and must be
provided if \code{model_fit$burnin} does not exist. See \code{\link{assess_convergence}}.}

\item{parameter}{Character string defining which parameter to compute
posterior intervals for. One of \code{"alpha"}, \code{"rho"}, or
\code{"cluster_probs"}. Default is \code{"alpha"}.}

\item{level}{Decimal number in \eqn{[0,1]} specifying the confidence level.
Defaults to \code{0.95}.}

\item{decimals}{Integer specifying the number of decimals to include
in posterior intervals and the mean and median. Defaults to \code{3}.}
}
\description{
Compute posterior intervals of parameters of interest.
}
\details{
This function computes both the Highest Posterior Density Interval (HPDI),
which may be discontinuous for bimodal distributions, and
the central posterior interval, which is simply defined by the quantiles of the posterior
distribution. The HPDI intervals are computed using the \code{HDInterval} package
\insertCite{meredith2018}{BayesMallows}.
}
\examples{
# The example datasets potato_visual and potato_weighing contain complete
# rankings of 20 items, by 12 assessors. We first analyse these using the Mallows
# model:
model_fit <- compute_mallows(potato_visual)

# Se the documentation to compute_mallows for how to assess the convergence of the algorithm
# Having chosen burin = 1000, we compute posterior intervals
model_fit$burnin <- 1000
# First we compute the interval for alpha
compute_posterior_intervals(model_fit, parameter = "alpha")
# We can reduce the number decimals
compute_posterior_intervals(model_fit, parameter = "alpha", decimals = 2)
# By default, we get a 95 \% interval. We can change that to 99 \%.
compute_posterior_intervals(model_fit, parameter = "alpha", level = 0.99)
# We can also compute the posterior interval for the latent ranks rho
compute_posterior_intervals(model_fit, parameter = "rho")

\dontrun{
  # Posterior intervals of cluster probabilities
  # We can run a mixture of Mallows models, using the n_clusters argument
  # We use the sushi example data. See the documentation of compute_mallows for a more elaborate
  # example
  model_fit <- compute_mallows(sushi_rankings, n_clusters = 5)
  # Keeping the burnin at 1000, we can compute the posterior intervals of the cluster probabilities
  compute_posterior_intervals(model_fit, burnin = 1000, parameter = "cluster_probs")
}


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{compute_mallows}}
}
