test_that("rank_freq_distr works", {
  expect_error(
    rank_freq_distr(rankings = beach_preferences)
  )

  expect_equal(
    rank_freq_distr(rankings = potato_visual),
    structure(c(10, 10, 10, 12, 12, 12, 14, 14, 7, 8, 9, 9, 15, 18,
                18, 15, 16, 17, 15, 18, 17, 16, 16, 17, 19, 19, 19, 18, 19, 19,
                19, 20, 19, 18, 19, 19, 16, 15, 17, 16, 15, 15, 16, 19, 18, 19,
                17, 16, 8, 6, 11, 13, 13, 7, 12, 11, 9, 12, 10, 10, 18, 16, 15,
                11, 18, 16, 18, 15, 15, 13, 15, 15, 6, 4, 6, 7, 7, 2, 8, 6, 5,
                6, 5, 5, 20, 20, 20, 20, 20, 20, 20, 17, 20, 20, 20, 20, 3, 3,
                4, 6, 3, 3, 3, 4, 3, 5, 3, 3, 7, 5, 3, 3, 5, 9, 4, 3, 10, 3,
                8, 4, 11, 12, 13, 8, 11, 13, 9, 10, 11, 7, 11, 8, 1, 1, 1, 2,
                1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 2, 4, 2, 2, 2, 4, 2, 2, 4,
                9, 7, 4, 6, 5, 7, 7, 6, 2, 6, 7, 17, 17, 16, 19, 17, 18, 17,
                16, 16, 17, 18, 18, 9, 8, 8, 5, 10, 11, 6, 8, 8, 10, 7, 11, 5,
                7, 5, 9, 4, 6, 5, 5, 4, 9, 4, 6, 13, 14, 12, 14, 14, 8, 13, 12,
                13, 15, 14, 13, 12, 13, 9, 10, 8, 10, 10, 9, 12, 14, 12, 14,
                14, 11, 14, 17, 9, 14, 11, 13, 14, 11, 13, 12, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1), .Dim = c(12L, 21L), .Dimnames = list(NULL,
                                                                           c("", "", "", "", "", "", "", "", "", "", "", "", "", "",
                                                                             "", "", "", "", "", "", "freq")))
  )

  set.seed(9988)
  rows <- unlist(purrr::map2(
    sample(20:100, nrow(potato_visual), replace = TRUE), 1:12, ~ rep(.y, each = .x)))
  mat <- potato_visual[rows, ]
  expect_equal(
    rank_freq_distr(rankings = mat),
    structure(c(10, 10, 10, 12, 12, 12, 14, 14, 7, 8, 9, 9, 15, 18,
                18, 15, 16, 17, 15, 18, 17, 16, 16, 17, 19, 19, 19, 18, 19, 19,
                19, 20, 19, 18, 19, 19, 16, 15, 17, 16, 15, 15, 16, 19, 18, 19,
                17, 16, 8, 6, 11, 13, 13, 7, 12, 11, 9, 12, 10, 10, 18, 16, 15,
                11, 18, 16, 18, 15, 15, 13, 15, 15, 6, 4, 6, 7, 7, 2, 8, 6, 5,
                6, 5, 5, 20, 20, 20, 20, 20, 20, 20, 17, 20, 20, 20, 20, 3, 3,
                4, 6, 3, 3, 3, 4, 3, 5, 3, 3, 7, 5, 3, 3, 5, 9, 4, 3, 10, 3,
                8, 4, 11, 12, 13, 8, 11, 13, 9, 10, 11, 7, 11, 8, 1, 1, 1, 2,
                1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 2, 4, 2, 2, 2, 4, 2, 2, 4,
                9, 7, 4, 6, 5, 7, 7, 6, 2, 6, 7, 17, 17, 16, 19, 17, 18, 17,
                16, 16, 17, 18, 18, 9, 8, 8, 5, 10, 11, 6, 8, 8, 10, 7, 11, 5,
                7, 5, 9, 4, 6, 5, 5, 4, 9, 4, 6, 13, 14, 12, 14, 14, 8, 13, 12,
                13, 15, 14, 13, 12, 13, 9, 10, 8, 10, 10, 9, 12, 14, 12, 14,
                14, 11, 14, 17, 9, 14, 11, 13, 14, 11, 13, 12, 98, 33, 88, 49,
                21, 97, 59, 45, 91, 98, 48, 23), .Dim = c(12L, 21L), .Dimnames = list(
                  NULL, c("", "", "", "", "", "", "", "", "", "", "", "", "",
                          "", "", "", "", "", "", "", "freq")))

  )

  expect_equal(
    rank_freq_distr(rankings = potato_visual[2, ]),
    structure(c(10, 18, 19, 17, 11, 15, 6, 20, 4, 3, 13, 1, 2, 7,
                16, 8, 5, 12, 9, 14, 1), .Dim = c(1L, 21L), .Dimnames = list(
                  NULL, c("", "", "", "", "", "", "", "", "", "", "", "", "",
                          "", "", "", "", "", "", "", "freq")))
  )
})

