% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{leap_and_shift_probs}
\alias{leap_and_shift_probs}
\title{Leap and Shift Probabilities}
\usage{
leap_and_shift_probs(rho, n_items, leap_size = 1L)
}
\arguments{
\item{rho}{A ranking sequence}

\item{n_items}{Integer is the number of items in a ranking}

\item{leap_size}{Integer specifying the step size of the leap-and-shift
proposal distribution.}
}
\value{
A list containing:
\itemize{
\item \code{rho_prime} A ranking sequence proposed consensus ranking
\item \code{forwards_prob} Numeric value to account for transition probability from rho to rho_prime
\item \code{backwards_prob} Numeric Value to account for the transition probability from \code{rho_prime} to \code{rho}
}
}
\description{
Calculates transition probabilities for proposing a new rho
}
\examples{
rho <- c(1, 2, 3, 4, 5, 6)
n_items <- 6

leap_and_shift_probs(rho, n_items, 1)
leap_and_shift_probs(rho, n_items, 2)
leap_and_shift_probs(rho, n_items, 3)

}
\keyword{internal}
