% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_blc.R
\name{plot.BLC}
\alias{plot.BLC}
\title{BLC: Plot the fitted values}
\usage{
\method{plot}{BLC}(x, parameter = "all", prob = 0.9, age = NULL, ...)
}
\arguments{
\item{x}{A \code{BLC} object, result of a call to blc() function.}

\item{parameter}{A character determines the parameter that will be plotted. Default is "all" which means that all three parameters "alpha", "beta" and "kappa" will be plotted. It can also be "alpha", "beta", "kappa" or "fitted". The last one provides a plot with all the fitted tables.}

\item{prob}{A numeric value that indicates the probability for the credible interval. Default is '0.9'.}

\item{age}{A numeric vector that represents the ages used in the fitted BLC model. Default is 'NULL'.}

\item{...}{Other arguments.}
}
\value{
A plot with the fitted log mortality or fitted values and credible intervals of the parameters.
}
\description{
This function plots the fitted log mortality values as well as the parameters values and credible intervals of the BLC fitted models.
}
\examples{
## Importing log-mortality data from Portugal:
data(PT)
Y <- PT

## Fitting the model
fit = blc(Y = Y, M = 100, bn = 20)

## Parameters' plot
plot(fit, parameter = "all")
\donttest{plot(fit, parameter = "beta", prob = 0.95)
plot(fit, parameter = "alpha", age = 18:80)
plot(fit, parameter = "kappa")

## Fitted mortality graduation
plot(fit, parameter = "fitted", age = 18:80)
}

}
\seealso{
\code{\link[=plot.HP]{plot.HP()}} and \code{\link[=plot.DLM]{plot.DLM()}} for \code{HP} or \code{DLM} methods.
}
