% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_dlm.R
\name{summary.DLM}
\alias{summary.DLM}
\title{DLM: Summary}
\usage{
\method{summary}{DLM}(object, digits = 5, ...)
}
\arguments{
\item{object}{A \code{DLM} or \code{ClosedDLM} object, result of a call to dlm() or dlm_close() function.}

\item{digits}{An integer indicating the number of decimals places.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A data.frame object with the mean, standard deviation and 2.5\%, 50\% and 97.5\% quantiles of a fitted \code{DLM} or \code{ClosedDLM} model.
}
\description{
Summarizes information from the parameters' markov chains of a fitted \code{DLM} or \code{ClosedDLM} model.
}
\examples{
## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

## Selecting the log mortality rate of the 2010 male population ranging from 0 to 100 years old
USA2010 = USA[USA$Year == 2010,]
x = 0:100
Ex = USA2010$Ex.Male[x+1]
Dx = USA2010$Dx.Male[x+1]
y = log(Dx/Ex)

## Fitting DLM
fit = dlm(y, M = 100)
summary(fit)

}
\seealso{
\code{\link[=summary.HP]{summary.HP()}} for \code{HP} method.
}
