% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfm_mcmc_spmix.R
\name{sfm_mcmc_spmix}
\alias{sfm_mcmc_spmix}
\title{Estimation of a mixture of shifted Poisson distributions.}
\usage{
sfm_mcmc_spmix(y, Jmax, M, prt = TRUE)
}
\arguments{
\item{y}{(a vector of integers) Observations used to fit the model.}

\item{Jmax}{(an integer) Maximum number of mixture components.}

\item{M}{(an integer) Number of MCMC iterations.}

\item{prt}{print intermediate of the MCMC estimation ? default = TRUE.}
}
\value{
A list containing:
\itemize{
  \item theta_draws : a (M x 3xJmax) matrix. Parameter draws from the posterior distribution at each MCMC iteration.
  \item p_draws : a (M x Jmax) matrix. Posterior draw of mixture weights at each MCMC iteration.
  \item kappa_draws : a (M x Jmax) matrix. Posterior draws of kappa at each MCMC iteration.
  \item lambda_draws : a (M x Jmax) matrix. Posterior draws of lambda at each MCMC iteration.
  \item snj : a (M x Jmax) matrix. Number of observations allocated to each components at each MCMC iteration.
  \item se0 : a vector of size M. Concentration parameter from (symmetric) Dirichlet distribution at each MCMC iteration.
  \item dist : a string indicating the distribution used in the mixture.
  \item y, Jmax and M, given as input.
}
}
\description{
Bayesian estimation of a mixture of shifted Poisson distributions using a Sparse Finite Mixture MCMC algorithm.
}
\examples{
# Example with simulated data ================================================
#set seed for random number generation
set.seed(1) 

# Set the parameters for drawing from a two-component shifted Poisson mixture
p1 = 0.3
p2 = 1-p1
kap1 = 3
kap2 = 0
lam1 = 1
lam2 = 0.5
length_data = 70

# Generate data
y <- c(rpois(length_data*p1, lam1)+kap1, rpois(length_data*p2, lam2)+kap2)

# Set parameters for the SFM MCMC estimation
M = 1000 # Number of MCMC iterations
Jmax = 4 # Maximum number of mixture components

# Estimation with SFM MCMC
sfm_mcmc = sfm_mcmc_spmix(y=y,Jmax=Jmax, M=M)

# Example with DNA data =====================================================
\donttest{
y = d4z4
M = 5000 # Number of MCMC iterations 
Jmax = 10 # Maximum number of mixture components

# Estimation with SFM MCMC
sfm_mcmc = sfm_mcmc_spmix(y=y,Jmax=Jmax, M=M)
}
}
\references{
\insertRef{malsiner-walli_model-based_2016}{BayesMultiMode}\cr
\insertRef{basturk_bayes_2021}{BayesMultiMode}
}
