% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_mode.R
\name{bayes_mode}
\alias{bayes_mode}
\title{Bayesian mode inference}
\usage{
bayes_mode(
  BayesMix,
  rd = 1,
  tol_x = sd(BayesMix$data)/10,
  show_plot = FALSE,
  nb_iter = NULL
)
}
\arguments{
\item{BayesMix}{An object of class `BayesMixture`}

\item{rd}{Rounding parameter}

\item{tol_x}{Tolerance parameter for distance in-between modes; default is sd(data)/10 where data is an element of BayesMix.
If two modes are closer than tol_x, only the first estimated mode is kept.
Not needed for mixtures of discrete distributions.}

\item{show_plot}{Show density with estimated mode as vertical bars ?}

\item{nb_iter}{Number of draws on which the mode-finding algorithm is run; default is NULL which means the algorithm is run on all draws.}
}
\value{
A list of class `BayesMode` containing
\itemize{
 \item{data}{ - from BayesMix argument}
 \item{dist}{ - from BayesMix argument}
 \item{dist_type}{ - from BayesMix argument}
 \item{pars_names}{ - from BayesMix argument}
 \item{modes}{ - Matrix with a row for each draw and columns showing modes}
 \item{p1}{ - Posterior probability of unimodality}
 \item{tb_nb_modes}{ - Matrix showing posterior probabilities for the number of modes}
 \item{table_location}{ - Matrix showing the posterior probabilities for location points being modes}
}
}
\description{
Estimates modes for each mcmc draws which are then used to compute posterior probabilities for the number of modes and their locations.
The fixed-point algorithm of Carreira-Perpinan (2000) is used for Gaussian mixtures
while the Modal EM algorithm of Li et al. (2007) is used for other continuous mixtures.
}
\examples{
# Example with galaxy data ================================================
set.seed(123) 

# retrieve galaxy data
y = galaxy

# estimation
bayesmix = bayes_estimation(data = y,
                           K = 5, #not many to run the example rapidly
                           dist = "normal",
                           nb_iter = 500, #not many to run the example rapidly
                           burnin = 100)

# mode estimation
bayesmode = bayes_mode(bayesmix)

# plot 
# plot(bayesmode, max_size = 200)

# summary 
# summary(bayesmode)

# Example with DNA data ================================================
set.seed(123) 

# retrieve galaxy data
y = d4z4

# estimation
bayesmix = bayes_estimation(data = y,
                           K = 5, #not many to run the example rapidly
                           dist = "shifted_poisson",
                           nb_iter = 500, #not many to run the example rapidly
                           burnin = 100)

# mode estimation
bayesmode = bayes_mode(bayesmix)

# plot 
# plot(bayesmode, max_size = 200)

# summary 
# summary(bayesmode)

}
\references{
\insertRef{carreira-perpinan_mode-finding_2000}{BayesMultiMode}\cr\cr
\insertRef{li_nonparametric_2007}{BayesMultiMode}
}
