% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.BayesSUR.R
\name{predict.BayesSUR}
\alias{predict.BayesSUR}
\title{predict responses corresponding to the posterior mean of the coefficients, return posterior mean of coefficients or indices of nonzero coefficients}
\usage{
\method{predict}{BayesSUR}(
  object,
  newx,
  type = c("response", "coefficients", "nonzero"),
  Pmax = 0,
  ...
)
}
\arguments{
\item{object}{an object of class "BayesSUR"}

\item{newx}{Matrix of new values for x at which predictions are to be made. Must be a matrix}

\item{type}{Type of prediction required. Type "response" gives the fitted responses. Type "coefficients" computes the coefficients 
truncated the estimated coefficients based on thresholding the estimated latent indicator variable at \code{Pmax}. 
Type "nonzero" returns a list of the indices of the nonzero coefficients corresponding to the estimated latent indicator variable thresholding at \code{Pmax}}

\item{Pmax}{threshold that truncates the estimated coefficients based on thresholding the estimated latent indicator variable. Default is 0.}

\item{...}{other arguments}
}
\value{
Predicted values extracted from an object of class "BayesSUR". If the \code{BayesSUR} specified data standardization, the fitted values are base based on standardized data.
}
\description{
Predict responses corresponding to the posterior mean of the coefficients, return posterior mean of coefficients or indices of nonzero coefficients of a "BayesSUR" class object.
}
\examples{
data("example_eQTL", package = "BayesSUR")
hyperpar <- list( a_w = 2 , b_w = 5 )

fit <- BayesSUR(Y = example_eQTL[["blockList"]][[1]], 
                X = example_eQTL[["blockList"]][[2]],
                data = example_eQTL[["data"]], outFilePath = tempdir(),
                nIter = 100, burnin = 50, nChains = 2, gammaPrior = "hotspot",
                hyperpar = hyperpar, tmpFolder = "tmp/" )

## check prediction
predict.val <- predict(fit, newx=example_eQTL[["blockList"]][[2]])

}
