% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ResponseGraph.R
\name{plot.ResponseGraph}
\alias{plot.ResponseGraph}
\title{plot the estimated graph for multiple response variables}
\usage{
\method{plot}{ResponseGraph}(
  x,
  PmaxResponse = 0.5,
  PtrueResponse = NULL,
  name.responses = NA,
  edge.weight = FALSE,
  label.color = "black",
  node.size = 30,
  node.color = "dodgerblue",
  ...
)
}
\arguments{
\item{x}{an object of class \code{getEstimator} with \code{estimator="Gy"}}

\item{PmaxResponse}{cutpoint for thresholding the learning structure matrix of multiple response variables. Default is 0.5}

\item{PtrueResponse}{true adjacency matrix for the structure of multiple response variables}

\item{name.responses}{A vector for the node names. The default is "NA" only to show the locations. Value "auto" show the response names from the orginal data.}

\item{edge.weight}{draw weighted edges after thresholding at 0.5. The defaul value "FALSE" is not to draw weigthed edges}

\item{label.color}{label color. Default is "black"}

\item{node.size}{node size. Default is 30}

\item{node.color}{node color. Default is "dodgerblue}

\item{...}{other arguments}
}
\description{
Plot the estimated graph for multiple response variables from a "BayesSUR" class object.
}
\examples{
data("example_eQTL", package = "BayesSUR")
hyperpar <- list( a_w = 2 , b_w = 5 )

set.seed(9173)
fit <- BayesSUR(Y = example_eQTL[["blockList"]][[1]], 
                X = example_eQTL[["blockList"]][[2]],
                data = example_eQTL[["data"]], outFilePath = tempdir(),
                nIter = 100, burnin = 50, nChains = 2, gammaPrior = "hotspot",
                hyperpar = hyperpar, tmpFolder = "tmp/" )

## check output
# show the graph relationship between responses
Gy <- getEstimator(fit, estimator = "Gy")
plot(Gy)

}
