% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotBayesSurv.R
\name{PlotBayesSurv}
\alias{PlotBayesSurv}
\title{Plot the posterior mean with credible band for the survival function
or cumulative hazard, or the posterior mean for the hazard}
\usage{
PlotBayesSurv(
  bayes.surv.object,
  object = c("survival", "cumhaz", "hazard"),
  band = TRUE,
  color = "darkblue",
  plot.title = "",
  xlab = "time",
  ylab = "",
  legend = TRUE,
  alpha.band = 0.4
)
}
\arguments{
\item{bayes.surv.object}{The output from the function \link{BayesSurv}.}

\item{object}{The object to be plotted, the user may select "survival"
for the survival function, "cumhaz" for the cumulative hazard, or
"hazard" for the hazard function. Default is the survival function.}

\item{band}{Indicator whether a credible band should be plotted (only
possible for the survival function and the cumulative hazard).}

\item{color}{The color to be used for the posterior mean and the
credible band (if applicable).}

\item{plot.title}{A title for the plot.}

\item{xlab}{A label for the horizontal axis.}

\item{ylab}{a label for the vertical axis.}

\item{legend}{If TRUE, a legend saying 'Credible band' will be included.}

\item{alpha.band}{The transparency of the credible band.}
}
\value{
\item{gg}{The plot, which may be edited further by adding
ggplot2 syntax.}
}
\description{
This function takes the output from \link{BayesSurv} and uses ggplot2
to make plots of (1) the posterior mean of the survival function
with credible band, or (2) the posterior mean of the cumulative hazard
with credible band, or (3) the posterior mean of the cumulative hazard.
Users can select some plotting options within this function. Further
changes to the plot can be made by storing the plot and adding
ggplot2 syntax (see the examples).
}
\details{
The posterior mean of the hazard and the posterior mean and credible
band of the cumulative hazard are plotted exactly. The survival is plotted
exactly at the points contained in the vector \code{surv.eval.grid} contained
in the object created by \link{BayesSurv}. Between these points, the survival
is linearly interpolated. To evaluate the survival exactly at more points
(and to obtain a smoother plot), increase the parameter \code{surv.factor}
within \link{BayesSurv}.
}
\examples{
#Demonstration on a simulated data set
library(simsurv)
library(ggplot2)
hazard.true <- function(t,x, betas, ...){1.2*(5*(t+0.05)^3 - 10*(t+0.05)^2 + 5*(t+0.05) ) + 0.7}
sim.df <- data.frame(id = 1:1000)
df <- simsurv(x = sim.df, maxt = 1, hazard = hazard.true)

bs <- BayesSurv(df, "eventtime", "status")
PlotBayesSurv(bs, object = "survival")

cumhaz.plot <- PlotBayesSurv(bs, object = "cumhaz")
cumhaz.plot + labs(title = "Cumulative hazard")

}
\references{
Castillo and Van der Pas (2020). Multiscale Bayesian survival
  analysis. <arXiv:2005.02889>.
}
\seealso{
\link{BayesSurv} to create the required object for this
plotting function.
}
