% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{check_input}
\alias{check_input}
\alias{check_bool}
\alias{check_char}
\alias{check_real}
\alias{check_int}
\alias{check_list}
\title{Check input}
\usage{
check_bool(x, name, check_length = 1, allow_NULL = FALSE, call = "")

check_char(
  x,
  name,
  check_length = 1,
  allow_values = NULL,
  allow_NULL = FALSE,
  call = ""
)

check_real(
  x,
  name,
  lower = -Inf,
  upper = Inf,
  allow_bound = TRUE,
  check_length = 1,
  allow_NULL = FALSE,
  call = ""
)

check_int(
  x,
  name,
  lower = -Inf,
  upper = Inf,
  allow_bound = TRUE,
  check_length = 1,
  allow_NULL = FALSE,
  call = ""
)

check_list(
  x,
  name,
  check_length = 0,
  check_names = NULL,
  all_objects = FALSE,
  allow_other = FALSE,
  allow_NULL = FALSE,
  call = ""
)
}
\arguments{
\item{x}{object to be checked}

\item{name}{name of the object that will be print in the error
message.}

\item{check_length}{length of the object to be checked. Defaults to
\code{1}. Set to \code{0} in order to not check object length.}

\item{allow_NULL}{whether the object can be \code{NULL}.
If so, no checks are executed.}

\item{call}{string to be placed as a prefix to the error call.}

\item{allow_values}{names of values allowed in a character vector.
Defaults to \code{NULL} (do not check).}

\item{lower}{lower bound of allowed values.
Defaults to \code{-Inf} (do not check).}

\item{upper}{upper bound of allowed values.
Defaults to \code{Inf} (do not check).}

\item{allow_bound}{whether the values at the boundary are allowed.
Defaults to \code{TRUE}.}

\item{check_names}{names of entries allowed in a list. Defaults to
\code{NULL} (do not check).}

\item{all_objects}{whether all entries in \code{check_names} must be
present. Defaults to \code{FALSE}.}

\item{allow_other}{whether additional entries then the specified in
\code{check_names} might be present}
}
\value{
returns \code{NULL}, called for the input check.
}
\description{
A set of convenience functions for checking
objects/arguments to a function passed by a user.
}
\examples{
# check whether the object is logical
check_bool(TRUE, name = "input")

# will throw an error on any other type
\dontrun{
  check_bool("TRUE", name = "input")
}

}
