\name{predictBvs}
\alias{predictBvs}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Bayesian Model Averaged predictions
}
\description{
Samples of the model averaged objective predictive distribution

}
\usage{predictBvs(x, newdata, n.sim=10000)}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{An object of class \code{Bvs}}
	\item{newdata}{A data frame in which to look for variables with
          which to predict}
  \item{n.sim }{Number of simulations to be produced}
}
\details{

The distribution that is sampled from is the discrete mixture of the (objective) predictive distribution with weights proportional to the posterior probabilities of each model. That is, from

    \eqn{latex}{       sum_M f(y^* | data, newdata, M) Pr(M | data)}

The models used in the mixture above are the retained best models (see the argument \code{n.keep} in \link[BayesVarSel]{Bvs}) if \code{x} was generated with \code{Bvs} and the sampled models with the associated frequencies if \code{x} was generated with \code{GibbsBvs}. The formula for the objective predictive distribution within each model \eqn{latex}{f(\beta | data, M)} is taken from Bernardo and Smith (1994) page 442.
 
}

\value{\code{predictBvs} returns a matrix with \code{n.sim} rows with the simulations. Each column of the matrix corresponds to each of the configurations for the covariates defined in \code{newdata}.}

\author{
Gonzalo Garcia-Donato and Anabel Forte

Maintainer: <anabel.forte@uv.es>
}

\seealso{
See \code{\link[BayesVarSel]{Bvs}}, \code{\link[BayesVarSel]{PBvs}} and \code{\link[BayesVarSel]{GibbsBvs}} for creating objects of the class \code{Bvs}.
}

\examples{
\dontrun{
	
#Analysis of Crime Data
#load data
data(UScrime)

crime.Bvs<- Bvs(formula="y~.", data=UScrime, n.keep=1000)
#predict a future observation associated with the first two sets of covariates
crime.Bvs.predict<- predictBvs(crime.Bvs, newdata=UScrime[1:2,], n.sim=10000)
#(Notice the best 1000 models are used in the mixture)

#Here you can use standard summaries to describe the underlying predictive distribution
#summary(crime.Bvs.predict)
#
#To study more in deep the first set:
#plot(density(crime.Bvs.predict[,1]))
#Point prediction
#median(crime.Bvs.predict[,1])
#A credible 95% interval for the prediction:
#lower bound:
#quantile(crime.Bvs.predict[,1], probs=0.025)
#upper bound:
#quantile(crime.Bvs.predict[,1], probs=0.975)

}
}

\references{
  Bernardo, J. M. and Smith, A. F. M. (1994)<DOI:10.1002/9780470316870> Bayesian Theory. Chichester: Wiley. 
}



