% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_utils.R
\name{GLMEM_objfn}
\alias{GLMEM_objfn}
\title{Objective function for the BayesGLM EM algorithm}
\usage{
GLMEM_objfn(theta, spde, model_data, Psi, K, A, num.threads = NULL, Ns = NULL)
}
\arguments{
\item{theta}{a vector containing kappa2, phi, and sigma2, in that order}

\item{spde}{the spde object}

\item{model_data}{the model_data object containing \code{y} and \code{X}}

\item{Psi}{a conversion matrix (N by V) (or N by n)}

\item{K}{number of covariates}

\item{A}{The value for Matrix::crossprod(X\%*\%Psi) (saves time on computation)}

\item{num.threads}{Needed for SQUAREM (it is an argument to the fixed-point functions)}

\item{Ns}{The number of samples used to approximate traces using the Hutchinson
estimator. If set to 0, the exact trace is found.}
}
\value{
A scalar value for the negative expected log-likelihood
}
\description{
This returns the negative of the expected log-likelihood function.
}
\keyword{internal}
