% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/p_value_of_the_Bayesian_sense_for_chi_square_goodness_of_fit.R
\name{chi_square_goodness_of_fit_from_input_all_param}
\alias{chi_square_goodness_of_fit_from_input_all_param}
\title{The Goodness of Fit (Chi Square) Calculator}
\usage{
chi_square_goodness_of_fit_from_input_all_param(h, f, p, lambda, NL, NI,
  ModifiedPoisson = FALSE, dig = 3)
}
\arguments{
\item{h}{The number of hits.
The reason why the author includes this variable is to substitute the false alarms from the posterior predictive distribution.
In famous Gelman's book, he explain how to make test statistics in the Bayesian context,  and it require the samples from posterior predictive distribution.
So, in this variable author substitute the replication data from the posterior predictive distributions.}

\item{f}{The number of false alarms.
The reason why the author includes this variable is to substitute the false alarms from the posterior predictive distribution.
In famous Gelman's book, he explain how to make test statistics in the Bayesian context,  and it require the samples from posterior predictive distribution.
So, in this variable author substitute the replication data from the posterior predictive distributions.}

\item{p}{Hit rate. A vector whose length is number of confidence levels.}

\item{lambda}{False alarm rate. A vector whose length is number of confidence levels.}

\item{NL}{Number of Lesions}

\item{NI}{Number of Images}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE}, then Poisson rate of false alarm is \code{per lesion},
and if \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm is \code{per image}.
To know detail, refer the author's paper in which I explained per image and per lesion.(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  })

If \code{ModifiedPoisson = TRUE},
 then False Positive Fraction (FPF) is calculated as follows
 (\eqn{f_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_L}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_L}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_L}, }

  \deqn{ \frac{f_4+f_5}{N_L}, }

   \deqn{ \frac{f_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_I}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_I}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_I}, }

  \deqn{ \frac{f_4+f_5}{N_I}, }

   \deqn{ \frac{f_5}{N_I}, }

where \eqn{N_I} is a number of images (trial).


So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it use only per trial. But, if we devide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author developed FROC theory to consider FROC analysis under per signal.


Revised 2019 6.19}

\item{dig}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \strong{rstan}. An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{...??}.   A positive integer representing   the Significant digits, used in stan Cancellation.
default = 5,}
}
\value{
Chi squares for each MCMC samples. So, the return values is a vector whose length is number of MCMC iterations minus the warming up period. Of course if MCMC is not only one chain, then taking the summation over all chains.

A number !! Not list nor dataframe nor vector !! Only A number represent the chi square for your input data.
}
\description{
Chi square goodness of fit statistics for each MCMC sample with a fixed dataset.



   Our data is 2C categories, that is,


 the number of hits        :h[1], h[2], h[3],...,h[C] and

 the number of false alarms: f[1],f[2], f[3],...,f[C].


   Our model has C+2 parameters, that is,

   the thresholds of the bi normal assumption z[1],z[2],z[3],...,z[C] and

   the mean and standard deviation of the signal distribution.


 So, the degree of freedom of this statistics is calculated by


            2C-(C+2)-1 =C -3.

This differ from Chakraborty's  result C-2. Why ?
}
\details{
To calculate the chi square test statistics, the two quantities are needed, that is, data and parameter. In the classical (frequentists) chi square values, as the estimates of parameter, for example, MLE (maximal likelihood estimator) is chosen. In Bayesian sense, the parameter can be taken for all MCMC iterations, that is, parameter is not deterministic and we consider it is a random variable or samples from the posterior distribution. And such samples are obtained in the Hamiltonian Monte Carlo Simulation with the author's  Bayesian Model. Thus we can calculate chi square values with MCMC samples.
}
\examples{
\donttest{

#  Get the MCMC samples from a dataset.

       fit <- fit_Bayesian_FROC(BayesianFROC::dataList.Chakra.1,
                           ite = 1111,
                           summary =FALSE,
                           cha = 2)

#   The chi square discrepancies are calculated
#   by the following code by using each MCMC samples as a parameter.#


  NI          <-  fit@dataList$NI
  NL          <-  fit@dataList$NL
  f.observed  <-  fit@dataList$f
  h.observed  <-  fit@dataList$h
  C           <-  fit@dataList$C
  p <-  rstan::get_posterior_mean(fit, par=c("p"))
  lambda <- rstan::get_posterior_mean(fit, par=c("l"))


         Chi.Square <-   chi_square_goodness_of_fit_from_input_all_param(

                          h   =   h.observed,
                          f   =   f.observed,
                          p   =   p,
                      lambda  =   lambda,
                          NL  =   NL,
                          NI  =   NI
                               )

#  Get posterior mean of the chi square discrepancy.

                    Chi.Square

# Calculate the p-value for the posterior mean of the chi square discrepancy.

                     stats::pchisq(Chi.Square,df=1)







}# dottest

}
