% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_error_srsc.R
\name{validation.dataset_srsc}
\alias{validation.dataset_srsc}
\title{Error between a give parameter and estimates for the parameters}
\usage{
validation.dataset_srsc(replicate.datset = 3, ModifiedPoisson = FALSE,
  mean.truth = 0.6, sd.truth = 5.3, z.truth = c(-0.8, 0.7, 2.38),
  NL = 259, NI = 57, ite = 1111, cha = 1, summary = TRUE,
  serial.number = 1, base_size = 0)
}
\arguments{
\item{replicate.datset}{A Number indicate
that how many you replicate dataset
from user's specified dataset.}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \emph{per lesion},
and model is fitted so that the FROC curve is a expected curve of TPF and FPF \emph{per lesion}.
If \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm is calculated \emph{per image},
and model is fitted so that the FROC curve is a expected curve of TPF and FPF \emph{per image}.
To know detail, see the author's paper in which I explained \emph{per image} and \emph{per lesion}.(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  })

If \code{ModifiedPoisson = TRUE},
 then the \emph{False Positive Fraction (FPF)} is calculated as follows
 (\eqn{f_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_L}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_L}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_L}, }

  \deqn{ \frac{f_4+f_5}{N_L}, }

   \deqn{ \frac{f_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_I}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_I}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_I}, }

  \deqn{ \frac{f_4+f_5}{N_I}, }

   \deqn{ \frac{f_5}{N_I}, }

where \eqn{N_I} is a number of images (trial).


The model is fitted so that the estimated FROC curve is on the FPF per image or per lesion accordingly.

If \code{ModifiedPoisson = TRUE}, then FROC curve means the expected pair of FPF \strong{per lesion} and TPF.

On the other hand, if  \code{ModifiedPoisson = FALSE}, then FROC curve means the expected pair of \strong{FPF per image} and TPF.




So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it uses only per images (trial). Since we can divide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author also developed FROC theory to consider FROC analysis under per signal.
One can see that the FROC curve is rigid with respect to change of a number of images, so, it does not matter whether \code{ModifiedPoisson = TRUE} or \code{FALSE}.

Revised 2019 August 28}

\item{mean.truth}{This is a parameter
of the latent Gaussian assumption
for the noise distribution.}

\item{sd.truth}{This is a parameter of the latent
Gaussian assumption for the noise distribution.}

\item{z.truth}{This is a parameter of the
latent Gaussian assumption for the noise distribution.}

\item{NL}{Number of Lesions.}

\item{NI}{Number of Images.}

\item{ite}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \pkg{rstan}. An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{iter}. A positive integer representing  the  number of samples generated by Hamiltonian Monte Carlo method,
and, default = 10000. If your model could not converge, then raise this number. Must be greater for more reliable estimates.}

\item{cha}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \pkg{rstan}. An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{chains}.  A positive integer representing   the number of chains generated by Hamiltonian Monte Carlo method,
and, default = 1.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}

\item{serial.number}{An positive integer
or Character. This is for programming perspective.
The author use this to print the serial
 numbre of validation. This will be used
 in the validation function.}

\item{base_size}{An numeric for size of object,
this is for the package developer.}
}
\value{
Return values is,

\describe{
\item{ Stanfit objects           }{  for each Replicated datasets   }
\item{ Errors                    }{ EAPs minus true values, in the above notations, it is \eqn{ \bar{\epsilon}(\theta_0,N_I,N_L)}    }
\item{  Variances of estimators. }{ This calculates the vaiance of posterior means over all replicated datasets   }
}
}
\description{
Let \eqn{\theta_0} be a given
model parameter with a given number of
images \eqn{N_I} and a given number
 of lesions \eqn{N_L}, specified by user.

\describe{
\item{ \strong{(I)} Replicates models for \eqn{D_1,D_2,...,D_k,...,D_K}.        }{          }
\item{ Draw a dataset \eqn{D_k}  from a likelihood (model), namely              }{ \eqn{D_k ~ likelihood(|\theta_0)}.                                                                  }
\item{ Draw a MCMC samples  \eqn{\{ \theta_i (D_k)\}} from a posterior, namely  }{ \eqn{ \theta _i ~ \pi(|D_k)}.                                                                       }
\item{ Calculate  a posterior mean,  namely                                     }{ \eqn{ \bar{\theta}(D_k) := \sum_i \theta_i(D_k) }.                                                  }
\item{ Calculates error                                                         }{ \eqn{\epsilon_k}:=Trueth - estimates =  \eqn{\theta_0   - \bar{\theta}(D_k)}                        }
\item{ \strong{(II)} Calculates mean of errors                                  }{ mean of errors  \eqn{ \bar{\epsilon}(\theta_0,N_I,N_L)}=  \eqn{ \frac{1}{K} \sum     \epsilon_k }   }
}

 Running this function, we can see that the error  \eqn{ \bar{\epsilon}(\theta_0,N_I,N_L)} decreases
 monotonically as a given number of images \eqn{N_I} or a given number of lesions \eqn{N_L} increases.

 Also, the scale of error also will be found. Thus this function can show how our estimates are correct.
Scale of error differs for each componenet of model parameters.



Revised 2019  August 28
}
\examples{
\donttest{
#===========================    The first example  ======================================



#   Using the default values, the code run, i.e.:

   datasets <- validation.dataset_srsc()



#=============================  The second example ======================================

#   If user do not familiar with the values of thresholds, then
#   it would be better to use the actual estimated values
#    as an example of true parameters. In the following,
#     I explain this.

# First, to get estimates, we run the following:

  fit <- fit_Bayesian_FROC(dataList.Chakra.1,ite = 1111,summary =FALSE,cha=3)






#  Secondly, extract the expected a posterior estimators (EAPs) from the object fit


  z <- rstan::get_posterior_mean(fit,par=c("z"))[,"mean-all chains"]





#  Thirdly we use this z as a true values.


   datasets <- validation.dataset_srsc(z.truth = z)



#----------------------------------------------------------------------------------------
#            1)             extract replicated fitted model object
#----------------------------------------------------------------------------------------


    # Replicates models

    a <- validation.dataset_srsc(replicate.datset = 3,ite = 111)



    # Check convergence, in the above MCMC iterations = 111 which is too small to get
    # a convergence MCMC chain, and thus the following example will the example
    # of a non-convergent model in the r hat criteria.

    ConfirmConvergence( a$fit[[3]])


    # Check trace plot to confirm whether MCMC chain do converge or not.

    stan_trace( a$fit[[3]],pars = "A")


   # Check p value
    ppp( a$fit[[3]])



    # In the above example, the posterior predictive p value is enough large,
    # but the model did not converge in R that criteria, which will cause
    # that the model does not fit to data. However p value is said
    # we can not reject the null hypothesis that the model does fit.
    # The author think this contradiction cause that the
    # number of MCMC iterations are too small which leads us to incorrect
    # Monte Carlo integral for p value. Thu p value is not correct.
    # Calculation of p value relies on the law of large number and thus
    # to obtain reliable posterior predictive p value, we need enough large
    # MCMC samples. 2019 August 29






                                          # Revised in 2019 August 29





#----------------------------------------------------------------------------------------
#            1)            Histogram of error of postrior means for replicated datasets
#----------------------------------------------------------------------------------------
#'

  a<-   validation.dataset_srsc(replicate.datset = 100)
  hist(a$error.of.AUC,breaks = 111)
  hist(a$error.of.AUC,breaks = 30)




}# donttest
}
