% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_dataset_MRMC.R
\docType{data}
\name{dddd}
\alias{dddd}
\title{One reader and Multiple modality data}
\description{
This is a subset of \code{ \link{dd}}. For this dataset, the function \code{\link{fit_Bayesian_FROC}() } well works.
So, even if the number of reader is one, my programm is available. Even if not available, I think it does not cause my model but my programming.


\describe{
\item{ dddd$M   }{  5 modalities   }
\item{ dddd$C   }{   5 Confidence levels }
\item{ dddd$Q   }{    1 readers}
}
}
\details{
Model converged in 2019 Jun 21.




\strong{Contents of dddd}


 \code{NL}  = 142 (Number of Lesions)

 \code{NI} = 199 (Number of Images)



\strong{\emph{ Contents:  }}

 \emph{          Multiple readers and multiple modalities case, i.e., MRMC case   }




---------------------------------------------------------------------------------------------------
\tabular{ccccc}{
 \strong{ModalityID } \tab   \strong{ReaderID }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{q} \tab  \code{ m}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
  -------------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr
1\tab 1\tab 5\tab  0\tab 50\cr
1\tab 1\tab 4\tab  4\tab 30\cr
1\tab 1\tab 3\tab 20\tab 11\cr
1\tab 1\tab 2\tab 29\tab 5\cr
1\tab 1\tab 1\tab 21\tab 1\cr
2\tab 1\tab 5\tab  1\tab 52\cr
2\tab 1\tab 4\tab  1\tab 25\cr
2\tab 1\tab 3\tab 21\tab 13\cr
2\tab 1\tab 2\tab 24\tab 4\cr
2\tab 1\tab 1\tab 23\tab 1\cr
3\tab 1\tab 5\tab  1\tab 43\cr
3\tab 1\tab 4\tab  7\tab 29\cr
3\tab 1\tab 3\tab 13\tab 11\cr
3\tab 1\tab 2\tab 28\tab 6\cr
3\tab 1\tab 1\tab 19\tab 0\cr
4\tab 1\tab 5\tab  1\tab 61\cr
4\tab 1\tab 4\tab  4\tab 19\cr
4\tab 1\tab 3\tab 18\tab 12\cr
4\tab 1\tab 2\tab 21\tab 9\cr
4\tab 1\tab 1\tab 23\tab 3\cr
5\tab 1\tab 5\tab  0\tab 35\cr
5\tab 1\tab 4\tab  2\tab 29\cr
5\tab 1\tab 3\tab 19\tab 18\cr
5\tab 1\tab 2\tab 23\tab 9\cr
5\tab 1\tab 1\tab 18\tab 0\cr}
---------------------------------------------------------------------------------------------------

The reason why the author made this data \code{dddd} is it has only one reader.
My program well work for more than two reader and more than two modality case. However,
the only one modality or only two modalitly is very special case for programming perspective,
and thus the author had to confirm whether my program well work in such cases.
For this dataset, the function \code{\link{fit_Bayesian_FROC}() } well works.
So, even if the number of reader is one, my programm is available. Even if not available, I think it does not cause my model but my programming.
}
\examples{


#----------------------------------------------------------------------------------------
#                        Show data by table
#----------------------------------------------------------------------------------------



                 viewdata(BayesianFROC::dddd)




#----------------------------------------------------------------------------------------
#              make an object dddd from an object dd
#----------------------------------------------------------------------------------------



           ddd  <-  data.frame(m=dd$m,q=dd$q,c=dd$c,h=dd$h,f=dd$f)

           dddd <-  ddd[ddd$q < 2,]  #  Reduce the dataset ddd, i.e., dd

ddd <- list(
           m=dddd$m,
           q=dddd$q,
           c=dddd$c,
           h=dddd$h,
           f=dddd$f,
           NL=142,
           C=max(dddd$c),
           M=max(dddd$m),
           Q=max(dddd$q)
        )

          dddd <-ddd


#----------------------------------------------------------------------------------------
#              Fit model to the object dddd
#----------------------------------------------------------------------------------------
#  Unfortunately, R CMD check require running time to be less than 5 which is difficult
#  for rstan::sampling(), thus, we cannot run the following from roxygen2 example.
#
#
#     For Fitting, execute the following R code;
#
#
#    fit <- fit_Bayesian_FROC(
#                              ite  = 1111,
#                               cha = 1,
#                           summary = F,
#                   Null.Hypothesis = F,
#                          dataList = dddd
#                                  )
#
#                                                              Revised 2019 July 10
#
#
}
\references{
Example data of Jafroc software
}
\seealso{
\code{\link{dataList.Chakra.Web} }
 \code{\link{dataList.Chakra.Web.orderd} }
  \code{\link{dd} }
}
\author{
Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
}
