% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waic.R
\name{waic}
\alias{waic}
\title{WAIC calculator}
\usage{
waic(StanS4classwithTargetFormulation, dig = 4, summary = TRUE)
}
\arguments{
\item{StanS4classwithTargetFormulation}{This is a fitted model
object built by \code{rstan::sampling()} whose model block
is described by target formulation
function in the \pkg{rstan} package. This object
is avaliable both S4 class, stanfit and \code{stanfitExtended}.

In this package, we make a new S4 class \code{stanfitExtended}
which is inherited class of rstan's S4 class named "stanfit".
This function is available for stanfit S4 object.}

\item{dig}{The number of significant digits of waic.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}
}
\value{
A real number, representing the value of WAIC.
}
\description{
Using the fitted object of class satnfit whose stan file described using \code{target += },
    the function calculates the WAIC.
}
\examples{
\donttest{
# First, we prepare the data endowed with this package:

        dat  <- get(data("dataList.Chakra.1"))




# Second,  create a fitted model object;

            fit <- fit_Bayesian_FROC(dat, PreciseLogLikelihood = TRUE)



# Using the fitted model object "fit", we obtain the WAIC



                 waic(fit)



#The Author provide two model for FROC for a single reader and a single modality case.
#One is false alarm rates means "per lesion" and the other means "per image".
#The above "fit" is "per image". Now we shall consider to compare these two model
#by WAIC. To do so, next we shall fit the "per lesion" model as follows:

fit2 <- fit_Bayesian_FROC(dat, PreciseLogLikelihood = TRUE, ModifiedPoisson=TRUE)

waic(fit2)



# By compare two model's WAIC we can say which model is better.
# Note that the smaller WAIC is better.

waic(fit)     # per lesion model
waic(fit2)    # per image model



# 2019.05.21 Revised.
}# dottest
}
