% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbc_MRMC.R
\name{Simulation_Based_Calibration_via_rstan_sbc_MRMC}
\alias{Simulation_Based_Calibration_via_rstan_sbc_MRMC}
\title{Simiulation Based Calibration (SBC) for a single reader and a single modality case}
\usage{
Simulation_Based_Calibration_via_rstan_sbc_MRMC(
  ww = -0.81,
  www = 0.001,
  mm = 0.65,
  mmm = 0.001,
  vv = 5.31,
  vvv = 0.001,
  zz = 1.55,
  zzz = 0.001,
  A_mean = 0.6,
  A_variance = 0.1,
  vv_hyper_v = 0.05,
  vvv_hyper_v = 0.01,
  NL = 259,
  NI = 57,
  C = 3,
  M = 5,
  Q = 4
)
}
\arguments{
\item{ww}{A real number representing parameter of prior, indicating mean of prior for the first threshold}

\item{www}{A real number representing parameter of prior, variance of prior for the first threshold}

\item{mm}{A real number representing parameter of prior, mean of prior for the mean of signal distribution}

\item{mmm}{A real number representing parameter of prior, variance of prior for the variance of signal distribution}

\item{vv}{A real number representing parameter of prior,  mean of prior for the mean of signal distribution}

\item{vvv}{A real number representing parameter of prior, variance of prior for the variance of signal distribution}

\item{zz}{A real number representing parameter of prior, mean of prior for the  differences of thresholds}

\item{zzz}{A real number representing parameter of prior, variance of prior for the  differences of thresholds}

\item{A_mean}{A real number representing parameter of prior, indicating mean of prior for the \code{A}}

\item{A_variance}{A real number representing parameter of prior, indicating mean of prior for the \code{A}}

\item{vv_hyper_v}{A real number representing parameter of prior, indicating mean of prior for the \code{hyper_v}}

\item{vvv_hyper_v}{A real number representing parameter of prior, indicating variance of prior for the  \code{hyper_v}}

\item{NL}{number of lesions}

\item{NI}{numver of images}

\item{C}{number of confidence levels}

\item{M}{number of modalities}

\item{Q}{number of readers}
}
\value{
A list of S3 class "sbc", which is an outputs of  the \code{sbc} function in rstan.
}
\description{
Implements the SBC algorithm for the a single reader and a single modality case.
}
\details{
The implementation is done using the rstan::sbc. The stan file is \code{SBC.stan}
}
\references{
Talts, S., Betancourt, M., Simpson, D., Vehtari, A., and Gelman, A. (2018).
 Validating Bayesian Inference Algorithms with Simulation-Based Calibration.
 arXiv preprint arXiv:1804.06788
}
\seealso{
\code{rstan::\link[rstan]{sbc}},\strong{\emph{ which implements SBC.}}

\strong{\emph{ Stan file: }}  SBC_MRMC.stan
}
