% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Screening_GP_optim.R
\name{GP.optim}
\alias{GP.optim}
\title{GP.optim: optimiser to give the next cutoff for evaluation}
\usage{
GP.optim(
  x,
  y,
  errorrate = 0.05,
  confidence.level = 0.95,
  grid.length = 5000,
  change.scale = FALSE,
  noise = T,
  grid.min,
  grid.max
)
}
\arguments{
\item{x}{A numeric vector of cutoff data}

\item{y}{A numeric vector of error rate data}

\item{errorrate}{A numeric value. The error rate we want to achieve. Error rate here means type I error rate or family-wise error rate. Default is 0.05.}

\item{confidence.level}{A numeric value indicating the confidence level of estimate. Default is 0.95}

\item{grid.length}{A numeric value indicating the grid resolution. Default is 5000.}

\item{change.scale}{A logic value indicating whether we want to change scale when doing Gaussian process. Default is FALSE.}

\item{noise}{A logic value indicating whether the input x is noisy. Default is TRUE.}

\item{grid.min}{A numeric value indicating the lower bound of the grid for screening.}

\item{grid.max}{A numeric value indicating the upper bound of the grid for screening.}
}
\value{
A list including the next cutoff value for evaluation \code{next.cutoff} and a list of predictions for screening grid.
}
\description{
A function to predict the next cutoff value for evaluation.
}
\examples{
x = c(7.123968, 6.449631, 1.984406,
3.507463, 4.972510, 2.925768,
5.816682, 4.367796,
7.349160, 1.113648)
y = c(0.0396, 0.0450,
0.5116, 0.2172,
0.1040, 0.3058,
0.0592, 0.1384,
0.0296, 0.7936)
grid.min=1
grid.max=8
GP.res=GP.optim(x=x, y=y, errorrate = 0.1, grid.min = grid.min, grid.max = grid.max)
GP.res$next.cutoff
}
\references{
Surrogates: Gaussian process modeling, design, and optimization for the applied sciences. CRC press. Gramacy, R.B., 2020.
Bayesian optimization for adaptive experimental design: A review. IEEE access, 8, 13937-13948. Greenhill, S., Rana, S., Gupta, S., Vellanki, P., & Venkatesh, S. (2020).
}
\author{
Ziyan Wang
}
