% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF.R
\name{GOF}
\alias{GOF}
\title{Standard GOF metrics
Startvalues for sampling with nrChains > 1 : if you want to provide different start values for the different chains, provide a list}
\usage{
GOF(observed, predicted, plot = F)
}
\arguments{
\item{observed}{observed values}

\item{predicted}{predicted values}

\item{plot}{should a plot be created}
}
\value{
A list with the following entries: rmse = root mean squared error, mae = mean absolute error, slope = slope of regression, offset = intercept of regression, R2 = R2 of regression
}
\description{
Standard GOF metrics
Startvalues for sampling with nrChains > 1 : if you want to provide different start values for the different chains, provide a list
}
\details{
The function considers predicted ~ observed and calculates

1) rmse = root mean squared error
2) mae = mean absolute errorr
3) a linear regression with slope, intercept and coefficient of determination R2

For the linear regression, the x axis is centered, meaning that the intercept is the difference between observed / predicted for the MEAN predicted value. This setting avoids a correlation between slope and intercept (that the intercept is != 0 as soon as the slope is !=0)
}
\examples{

x = runif(500,-1,1)
y = 0.2 + 0.9  *x + rnorm(500, sd = 0.5)

summary(lm(y ~ x))

GOF(x,y)

GOF(x,y, plot = TRUE)
}
\author{
Florian Hartig
}
