% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcTwalk_helperFunctions.R
\name{TwalkMove}
\alias{TwalkMove}
\title{Wrapper for step function}
\usage{
TwalkMove(Npar, FUN, x, Eval, x2, Eval2, at = 6, aw = 1.5, pn1 = min(Npar,
  4)/Npar, Ptrav = 0.4918, Pwalk = 0.4918, Pblow = 0.0082,
  Phop = 0.0082)
}
\arguments{
\item{Npar}{Number of parameters}

\item{FUN}{Log posterior density}

\item{x}{parameter vector of chain 1}

\item{Eval}{last evaluation of x}

\item{x2}{parameter vector of chain 2}

\item{Eval2}{last evaluation of x}

\item{at}{"traverse" move proposal parameter.}

\item{aw}{"walk" move proposal parameter.}

\item{pn1}{Probability determining the number of parameters that are changed.}

\item{Ptrav}{Move probability of "traverse" moves, default to 0.4918}

\item{Pwalk}{Move probability of "walk" moves, default to 0.4918}

\item{Pblow}{Move probability of "blow" moves, default to 0.0082}

\item{Phop}{Move probability of "hop" moves}
}
\description{
Wrapper for step function
}
\references{
Christen, J. Andres, and Colin Fox. "A general purpose sampling algorithm for continuous distributions (the t-walk)." Bayesian Analysis 5.2 (2010): 263-281.
}
\keyword{internal}
