/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.ContinuousDataType;
import dr.evolution.datatype.GeneralDataType;
import dr.evolution.datatype.GeneticCode;
import dr.evolution.datatype.HiddenAminoAcids;
import dr.evolution.datatype.HiddenCodons;
import dr.evolution.datatype.HiddenNucleotides;
import dr.evolution.datatype.Microsatellite;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.datatype.OldHiddenNucleotides;
import dr.evolution.datatype.P2P;
import dr.evolution.datatype.TwoStateCovarion;
import dr.evolution.datatype.TwoStates;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public abstract class DataType
implements Serializable {
    public static final String DATA_TYPE = "dataType";
    public static final int NUCLEOTIDES = 0;
    public static final int AMINO_ACIDS = 1;
    public static final int CODONS = 2;
    public static final int TWO_STATES = 3;
    public static final int GENERAL = 4;
    public static final int COVARION = 5;
    public static final int MICRO_SAT = 6;
    public static final int P2PTYPE = 7;
    public static final int CONTINUOUS = 8;
    public static final char UNKNOWN_CHARACTER = '?';
    public static final char GAP_CHARACTER = '-';
    protected int stateCount;
    protected int ambiguousStateCount;
    private static Map<String, DataType> registeredDataTypes = null;

    private static void lazyRegisterDataTypes() {
        if (registeredDataTypes == null) {
            registeredDataTypes = new Hashtable<String, DataType>();
            DataType.registerDataType("nucleotide", Nucleotides.INSTANCE);
            DataType.registerDataType("amino acid", AminoAcids.INSTANCE);
            DataType.registerDataType("codon-" + GeneticCode.UNIVERSAL.getName(), Codons.UNIVERSAL);
            DataType.registerDataType("codon-" + GeneticCode.VERTEBRATE_MT.getName(), Codons.VERTEBRATE_MT);
            DataType.registerDataType("codon-" + GeneticCode.YEAST.getName(), Codons.YEAST);
            DataType.registerDataType("codon-" + GeneticCode.MOLD_PROTOZOAN_MT.getName(), Codons.MOLD_PROTOZOAN_MT);
            DataType.registerDataType("codon-" + GeneticCode.MYCOPLASMA.getName(), Codons.MYCOPLASMA);
            DataType.registerDataType("codon-" + GeneticCode.INVERTEBRATE_MT.getName(), Codons.INVERTEBRATE_MT);
            DataType.registerDataType("codon-" + GeneticCode.CILIATE.getName(), Codons.CILIATE);
            DataType.registerDataType("codon-" + GeneticCode.ECHINODERM_MT.getName(), Codons.ECHINODERM_MT);
            DataType.registerDataType("codon-" + GeneticCode.EUPLOTID_NUC.getName(), Codons.EUPLOTID_NUC);
            DataType.registerDataType("codon-" + GeneticCode.BACTERIAL.getName(), Codons.BACTERIAL);
            DataType.registerDataType("codon-" + GeneticCode.ALT_YEAST.getName(), Codons.ALT_YEAST);
            DataType.registerDataType("codon-" + GeneticCode.ASCIDIAN_MT.getName(), Codons.ASCIDIAN_MT);
            DataType.registerDataType("codon-" + GeneticCode.FLATWORM_MT.getName(), Codons.FLATWORM_MT);
            DataType.registerDataType("codon-" + GeneticCode.BLEPHARISMA_NUC.getName(), Codons.BLEPHARISMA_NUC);
            DataType.registerDataType("codon-" + GeneticCode.NO_STOPS.getName(), Codons.NO_STOPS);
            DataType.registerDataType("binary", TwoStates.INSTANCE);
            DataType.registerDataType("hiddenNucleotide", OldHiddenNucleotides.INSTANCE);
            DataType.registerDataType("twoStateCovarion", TwoStateCovarion.INSTANCE);
            DataType.registerDataType("hiddenCodon2-" + GeneticCode.UNIVERSAL.getName(), HiddenCodons.UNIVERSAL_HIDDEN_2);
            DataType.registerDataType("hiddenCodon3-" + GeneticCode.UNIVERSAL.getName(), HiddenCodons.UNIVERSAL_HIDDEN_3);
            DataType.registerDataType("hiddenCodon4-" + GeneticCode.UNIVERSAL.getName(), HiddenCodons.UNIVERSAL_HIDDEN_4);
            DataType.registerDataType("hiddenCodon5-" + GeneticCode.UNIVERSAL.getName(), HiddenCodons.UNIVERSAL_HIDDEN_5);
            DataType.registerDataType("hiddenNucleotide1", HiddenNucleotides.NUCLEOTIDE_HIDDEN_1);
            DataType.registerDataType("hiddenNucleotide2", HiddenNucleotides.NUCLEOTIDE_HIDDEN_2);
            DataType.registerDataType("hiddenNucleotide3", HiddenNucleotides.NUCLEOTIDE_HIDDEN_3);
            DataType.registerDataType("hiddenNucleotide4", HiddenNucleotides.NUCLEOTIDE_HIDDEN_4);
            DataType.registerDataType("hiddenNucleotide8", HiddenNucleotides.NUCLEOTIDE_HIDDEN_8);
            DataType.registerDataType("hiddenAminoAcid1", HiddenAminoAcids.AMINO_ACIDS_HIDDEN_1);
            DataType.registerDataType("hiddenAminoAcid2", HiddenAminoAcids.AMINO_ACIDS_HIDDEN_2);
            DataType.registerDataType("hiddenAminoAcid3", HiddenAminoAcids.AMINO_ACIDS_HIDDEN_3);
            DataType.registerDataType("hiddenAminoAcid4", HiddenAminoAcids.AMINO_ACIDS_HIDDEN_4);
            DataType.registerDataType("generalDataType", GeneralDataType.INSTANCE);
            DataType.registerDataType("microsatellite", Microsatellite.INSTANCE);
            DataType.registerDataType("P2P", P2P.INSTANCE);
            DataType.registerDataType("continuous", ContinuousDataType.INSTANCE);
        }
    }

    public static void registerDataType(String string, DataType dataType) {
        DataType.lazyRegisterDataTypes();
        registeredDataTypes.put(string, dataType);
    }

    public static DataType getRegisteredDataTypeByName(String string) {
        DataType.lazyRegisterDataTypes();
        return registeredDataTypes.get(string);
    }

    public static String[] getRegisteredDataTypeNames() {
        DataType.lazyRegisterDataTypes();
        Set<String> set = registeredDataTypes.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set);
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public static DataType guessDataType(String string) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = Nucleotides.INSTANCE.getState(c);
            if (n != 16 && n != 17) {
                ++l;
            }
            if (c != '-' && c != '?') {
                ++l2;
            }
            if (c != '0' && c != '1') continue;
            ++l3;
        }
        if (l2 == 0L) {
            return Nucleotides.INSTANCE;
        }
        if ((double)l / (double)l2 > 0.85) {
            return Nucleotides.INSTANCE;
        }
        if ((double)l3 / (double)l2 > 0.2) {
            return TwoStates.INSTANCE;
        }
        return AminoAcids.INSTANCE;
    }

    public abstract char[] getValidChars();

    public int getStateCount() {
        return this.stateCount;
    }

    public int getAmbiguousStateCount() {
        return this.ambiguousStateCount;
    }

    public int getState(String string) {
        return this.getState(string.charAt(0));
    }

    public int getState(char c) {
        return c - 65;
    }

    public int getUnknownState() {
        return this.stateCount;
    }

    public int getGapState() {
        return this.stateCount + 1;
    }

    public char getChar(int n) {
        return (char)(n + 65);
    }

    public String getCode(int n) {
        return String.valueOf(this.getChar(n));
    }

    public String getTriplet(int n) {
        return " " + this.getChar(n) + " ";
    }

    public int[] getStates(int n) {
        int[] nArray;
        if (!this.isAmbiguousState(n)) {
            nArray = new int[]{n};
        } else {
            nArray = new int[this.stateCount];
            for (int i = 0; i < this.stateCount; ++i) {
                nArray[i] = i;
            }
        }
        return nArray;
    }

    public boolean[] getStateSet(int n) {
        boolean[] blArray = new boolean[this.stateCount];
        if (!this.isAmbiguousState(n)) {
            for (int i = 0; i < this.stateCount; ++i) {
                blArray[i] = false;
            }
            blArray[n] = true;
        } else {
            for (int i = 0; i < this.stateCount; ++i) {
                blArray[i] = true;
            }
        }
        return blArray;
    }

    public double getObservedDistance(int n, int n2) {
        if (!this.isAmbiguousState(n) && !this.isAmbiguousState(n2) && n != n2) {
            return 1.0;
        }
        return 0.0;
    }

    public double getObservedDistanceWithAmbiguity(int n, int n2) {
        boolean[] blArray = this.getStateSet(n);
        boolean[] blArray2 = this.getStateSet(n2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.stateCount; ++i) {
            if (blArray[i]) {
                d2 += 1.0;
                if (blArray[i] == blArray2[i]) {
                    d += 1.0;
                }
            }
            if (!blArray2[i]) continue;
            d3 += 1.0;
        }
        return 1.0 - d / (d2 * d3);
    }

    public String toString() {
        return this.getDescription();
    }

    public abstract String getDescription();

    public abstract int getType();

    public boolean isAmbiguousChar(char c) {
        return this.isAmbiguousState(this.getState(c));
    }

    public boolean isUnknownChar(char c) {
        return this.isUnknownState(this.getState(c));
    }

    public boolean isGapChar(char c) {
        return this.isGapState(this.getState(c));
    }

    public boolean isAmbiguousState(int n) {
        return n >= this.stateCount;
    }

    public boolean isUnknownState(int n) {
        return n == this.getUnknownState();
    }

    public boolean isGapState(int n) {
        return n == this.getGapState();
    }

    public String getName() {
        switch (this.getType()) {
            case 0: {
                return "Nucleotide";
            }
            case 1: {
                return "Amino Acid";
            }
            case 2: {
                return "Codon";
            }
            case 3: {
                return "Binary";
            }
            case 5: {
                return "Covarion";
            }
            case 4: {
                return "Discrete Traits";
            }
            case 8: {
                return "Continuous Traits";
            }
            case 6: {
                return "Microsatellite";
            }
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DataType)) {
            return false;
        }
        DataType dataType = (DataType)object;
        return this.getType() == dataType.getType();
    }

    public int hashCode() {
        return this.getType();
    }
}

