/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.statistics;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class AnnotateMuTreeTrait
implements TreeTraitProvider {
    protected TreeTraitProvider.Helper treeTraits = new TreeTraitProvider.Helper();
    private TreeModel treeModel;
    public static final String ANNOTATEMUPARAMETERTREETRAIT = "annotateMuTreeTrait";
    public static final String muParameterStr = "mu";
    public static final String indicatorsStr = "indicators";
    public static final String hasDriftStr = "hasDrift";
    public static final String MU1_SCALE_PARAMETER = "mu1Scale";
    public static final String MU2_SCALE_PARAMETER = "mu2Scale";
    public static final String MUMEAN_PARAMETER = "muMean";
    private MatrixParameter muParameter;
    private Parameter indicators;
    private Parameter mu1ScaleParameter;
    private Parameter mu2ScaleParameter;
    private Parameter muMeanParameter;
    private boolean hasDrift;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class), new ElementRule("mu", MatrixParameter.class), new ElementRule("indicators", Parameter.class), new ElementRule("mu1Scale", Parameter.class, "Optional parameter for scaling the first dimension of mu"), new ElementRule("mu2Scale", Parameter.class, "Optional parameter for scaling the second dimension of mu"), new ElementRule("muMean", Parameter.class), AttributeRule.newBooleanRule("hasDrift", true, "whether to multiple the mu by the drift term")};

        @Override
        public String getParserName() {
            return AnnotateMuTreeTrait.ANNOTATEMUPARAMETERTREETRAIT;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            XMLObject xMLObject2 = xMLObject.getChild(AnnotateMuTreeTrait.muParameterStr);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(AnnotateMuTreeTrait.indicatorsStr);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            boolean bl = xMLObject.getAttribute(AnnotateMuTreeTrait.hasDriftStr, false);
            Parameter parameter2 = null;
            if (xMLObject.hasChildNamed(AnnotateMuTreeTrait.MU1_SCALE_PARAMETER)) {
                parameter2 = (Parameter)xMLObject.getElementFirstChild(AnnotateMuTreeTrait.MU1_SCALE_PARAMETER);
            }
            Parameter parameter3 = null;
            if (xMLObject.hasChildNamed(AnnotateMuTreeTrait.MU2_SCALE_PARAMETER)) {
                parameter3 = (Parameter)xMLObject.getElementFirstChild(AnnotateMuTreeTrait.MU2_SCALE_PARAMETER);
            }
            Parameter parameter4 = null;
            if (xMLObject.hasChildNamed(AnnotateMuTreeTrait.MUMEAN_PARAMETER)) {
                parameter4 = (Parameter)xMLObject.getElementFirstChild(AnnotateMuTreeTrait.MUMEAN_PARAMETER);
            }
            return new AnnotateMuTreeTrait(treeModel, matrixParameter, parameter, bl, parameter2, parameter3, parameter4);
        }

        @Override
        public String getParserDescription() {
            return "Integrate mu coordinates into the tree.";
        }

        @Override
        public Class getReturnType() {
            return AnnotateMuTreeTrait.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public AnnotateMuTreeTrait(TreeModel treeModel, MatrixParameter matrixParameter, Parameter parameter, boolean bl, Parameter parameter2, Parameter parameter3, Parameter parameter4) {
        this.treeModel = treeModel;
        this.muParameter = matrixParameter;
        this.indicators = parameter;
        this.mu1ScaleParameter = parameter2;
        this.mu2ScaleParameter = parameter3;
        this.muMeanParameter = parameter4;
        this.hasDrift = bl;
        this.treeTraits.addTrait(new TreeTrait.IA(){

            @Override
            public String getTraitName() {
                return AnnotateMuTreeTrait.muParameterStr;
            }

            @Override
            public String getTraitString(Tree tree, NodeRef nodeRef) {
                if (tree != AnnotateMuTreeTrait.this.treeModel) {
                    System.out.println("Something is wrong. Why is tree not equal to treeModel?");
                    System.exit(0);
                }
                String string = "{0,0}";
                if ((int)AnnotateMuTreeTrait.this.indicators.getParameterValue(nodeRef.getNumber()) == 1) {
                    double d = AnnotateMuTreeTrait.this.muParameter.getParameter(nodeRef.getNumber()).getParameterValue(0);
                    double d2 = AnnotateMuTreeTrait.this.muParameter.getParameter(nodeRef.getNumber()).getParameterValue(1);
                    if (AnnotateMuTreeTrait.this.hasDrift && AnnotateMuTreeTrait.this.mu1ScaleParameter != null && AnnotateMuTreeTrait.this.muMeanParameter != null) {
                        d *= AnnotateMuTreeTrait.this.mu1ScaleParameter.getParameterValue(0);
                    }
                    if (AnnotateMuTreeTrait.this.hasDrift && AnnotateMuTreeTrait.this.mu2ScaleParameter != null) {
                        d2 *= AnnotateMuTreeTrait.this.mu2ScaleParameter.getParameterValue(0);
                    }
                    string = "{" + d + "," + d2 + "}";
                }
                return string;
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.NODE;
            }

            @Override
            public Class getTraitClass() {
                System.out.println("getTraitClass ran. Not expected. Quit now");
                System.exit(0);
                return int[].class;
            }

            @Override
            public int[] getTrait(Tree tree, NodeRef nodeRef) {
                System.out.println("getTrait ran. Not expected. Quit now");
                System.exit(0);
                return null;
            }
        });
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.treeTraits.getTreeTraits();
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        System.out.println("not expected to run getTreeTrait. Quit now");
        System.exit(0);
        return this.treeTraits.getTreeTrait(string);
    }
}

