/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExponentialGrowth;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodelxml.coalescent.demographicmodel.EmergingEpidemicModelParser;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;

public class EmergingEpidemicModel
extends DemographicModel {
    private final Parameter growthRateParameter;
    private final Parameter generationTimeParameter;
    private final Parameter generationShapeParameter;
    private final Parameter offspringDispersionParameter;
    private final TreeModel treeModel;
    private final ExponentialGrowth exponentialGrowth;

    public EmergingEpidemicModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, TreeModel treeModel, Units.Type type) {
        this(EmergingEpidemicModelParser.EMERGING_EPIDEMIC_MODEL, parameter, parameter2, parameter3, parameter4, treeModel, type);
    }

    public EmergingEpidemicModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, TreeModel treeModel, Units.Type type) {
        super(string);
        this.exponentialGrowth = new ExponentialGrowth(type);
        this.growthRateParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
        this.generationTimeParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
        this.generationShapeParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
        this.offspringDispersionParameter = parameter4;
        this.addVariable(parameter4);
        parameter4.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
        this.treeModel = treeModel;
        this.addModel(treeModel);
        this.addStatistic(new N0Statistic("N0"));
        this.addStatistic(new RStatistic("R"));
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.exponentialGrowth.setN0(this.getN0());
        this.exponentialGrowth.setGrowthRate(this.growthRateParameter.getParameterValue(0));
        return this.exponentialGrowth;
    }

    public double getR() {
        double d = this.growthRateParameter.getParameterValue(0);
        double d2 = this.generationTimeParameter.getParameterValue(0);
        double d3 = this.generationShapeParameter.getParameterValue(0);
        double d4 = Math.pow(1.0 + d * d2 / d3, d3);
        return d4;
    }

    public double getN0() {
        double d = this.getR();
        double d2 = this.treeModel.getNodeHeight(this.treeModel.getRoot());
        double d3 = this.growthRateParameter.getParameterValue(0);
        double d4 = this.generationTimeParameter.getParameterValue(0);
        double d5 = this.offspringDispersionParameter.getParameterValue(0);
        double d6 = d5 * d4 * Math.exp(d3 * d2) / (d * (d5 + d));
        return d6;
    }

    public class RStatistic
    extends Statistic.Abstract {
        public RStatistic(String string) {
            super(string);
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            return EmergingEpidemicModel.this.getR();
        }
    }

    public class N0Statistic
    extends Statistic.Abstract {
        public N0Statistic(String string) {
            super(string);
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            return EmergingEpidemicModel.this.getN0();
        }
    }
}

