/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.speciation;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ScaledDemographic;
import dr.evolution.tree.NodeRef;
import dr.evolution.util.Units;
import dr.evomodel.alloppnet.speciation.MulSpeciesBindings;
import dr.evomodel.alloppnet.speciation.MulSpeciesTreeModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import java.util.Arrays;
import jebl.util.FixedBitSet;

public class MulMSCoalescent
extends Likelihood.Abstract
implements Units {
    private final MulSpeciesTreeModel spTree;
    private final MulSpeciesBindings mulspb;
    private boolean checkCompatibility;
    private final boolean[] compatibleCheckRequired;
    int ccc = 0;
    private final boolean verbose = false;

    public MulMSCoalescent(MulSpeciesBindings mulSpeciesBindings, MulSpeciesTreeModel mulSpeciesTreeModel) {
        super(mulSpeciesTreeModel);
        MulSpeciesBindings.GeneTreeInfo[] geneTreeInfoArray;
        this.spTree = mulSpeciesTreeModel;
        this.mulspb = mulSpeciesBindings;
        this.spTree.addModelRestoreListener(this);
        for (MulSpeciesBindings.GeneTreeInfo geneTreeInfo : geneTreeInfoArray = mulSpeciesBindings.getGeneTrees()) {
            geneTreeInfo.tree.addModelListener(this);
        }
        this.compatibleCheckRequired = new boolean[geneTreeInfoArray.length];
        Arrays.fill(this.compatibleCheckRequired, false);
        this.checkCompatibility = false;
    }

    @Override
    public void modelRestored(Model model) {
        super.makeDirty();
    }

    @Override
    public void makeDirty() {
        super.makeDirty();
        this.checkCompatibility = true;
        for (int i = 0; i < this.mulspb.getGeneTrees().length; ++i) {
            this.compatibleCheckRequired[i] = true;
        }
    }

    @Override
    protected double calculateLogLikelihood() {
        int n;
        if (this.checkCompatibility) {
            n = 1;
            for (int i = 0; i < this.compatibleCheckRequired.length; ++i) {
                if (!this.compatibleCheckRequired[i]) continue;
                if (!this.spTree.isCompatible(this.mulspb.getGeneTrees()[i])) {
                    n = 0;
                }
                this.compatibleCheckRequired[i] = false;
            }
            if (n == 0) {
                return Double.NEGATIVE_INFINITY;
            }
            this.checkCompatibility = false;
        }
        for (n = 0; n < this.mulspb.getGeneTrees().length; ++n) {
            if (this.spTree.isCompatible(this.mulspb.getGeneTrees()[n])) continue;
            return Double.NEGATIVE_INFINITY;
        }
        double d = 0.0;
        int[] nArray = new int[]{0, 0};
        for (MulSpeciesBindings.GeneTreeInfo geneTreeInfo : this.mulspb.getGeneTrees()) {
            double d2 = this.treeLogLikelihood(geneTreeInfo, this.spTree.getRoot(), nArray, geneTreeInfo.popFactor());
            assert (!Double.isNaN(d2));
            d += d2;
        }
        ++this.ccc;
        return d;
    }

    private double treeLogLikelihood(MulSpeciesBindings.GeneTreeInfo geneTreeInfo, NodeRef nodeRef, int[] nArray, double d) {
        double d2;
        int n;
        int n2;
        int n3 = 0;
        double d3 = 0.0;
        double d4 = this.spTree.getNodeHeight(nodeRef);
        MulSpeciesBindings.CoalInfo[] coalInfoArray = geneTreeInfo.getCoalInfo();
        if (this.spTree.isExternal(nodeRef)) {
            n2 = geneTreeInfo.nLineages(this.spTree.speciesIndex(nodeRef));
            n3 = 0;
        } else {
            n2 = 0;
            for (n = 0; n < 2; ++n) {
                NodeRef nodeRef2 = this.spTree.getChild(nodeRef, n);
                d3 += this.treeLogLikelihood(geneTreeInfo, nodeRef2, nArray, d);
                n2 += nArray[0];
                n3 = Math.max(n3, nArray[1]);
            }
            if (n3 >= coalInfoArray.length) {
                System.err.println("ERROR in evomodel.speciation.MulMSCoalescent.treeLogLikelihood()");
            }
            assert (n3 < coalInfoArray.length);
            while (coalInfoArray[n3].ctime < d4) {
                ++n3;
            }
        }
        n = this.spTree.isRoot(nodeRef) ? 1 : 0;
        double d5 = n != 0 ? Double.MAX_VALUE : this.spTree.getNodeHeight(this.spTree.getParent(nodeRef));
        double d6 = 0.0;
        DemographicFunction demographicFunction = this.spTree.getNodeDemographic(nodeRef);
        if (d > 0.0) {
            demographicFunction = new ScaledDemographic(demographicFunction, d);
        }
        FixedBitSet fixedBitSet = this.spTree.spSet(nodeRef);
        while (n2 > 1) {
            assert (n3 < coalInfoArray.length);
            d2 = coalInfoArray[n3].ctime;
            if (d2 >= d5) break;
            if (this.nonEmptyIntersection(coalInfoArray[n3].sinfo, fixedBitSet)) {
                double d7 = d2 - d4;
                if (d7 > 0.0) {
                    double d8 = demographicFunction.getIntegral(d6, d7);
                    d6 = d7;
                    int n4 = n2 * (n2 - 1) / 2;
                    d3 -= (double)n4 * d8;
                    double d9 = demographicFunction.getDemographic(d7);
                    assert (d9 > 0.0);
                    d3 -= Math.log(d9);
                }
                --n2;
            }
            ++n3;
        }
        if (n2 > 1) {
            d2 = demographicFunction.getIntegral(d6, d5 - d4);
            int n5 = n2 * (n2 - 1) / 2;
            d3 -= (double)n5 * d2;
        }
        nArray[0] = n2;
        nArray[1] = n3;
        return d3;
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
        block2: {
            block1: {
                super.makeDirty();
                if (model != this.spTree) break block1;
                if (object != this.spTree || n == -1) break block2;
                this.checkCompatibility = true;
                Arrays.fill(this.compatibleCheckRequired, true);
                break block2;
            }
            MulSpeciesBindings.GeneTreeInfo[] geneTreeInfoArray = this.mulspb.getGeneTrees();
            for (int i = 0; i < this.mulspb.getGeneTrees().length; ++i) {
                if (geneTreeInfoArray[i].tree != model) continue;
                this.checkCompatibility = true;
                this.compatibleCheckRequired[i] = true;
                break;
            }
        }
    }

    private boolean nonEmptyIntersection(FixedBitSet[] fixedBitSetArray, FixedBitSet fixedBitSet) {
        for (FixedBitSet fixedBitSet2 : fixedBitSetArray) {
            if (fixedBitSet2.intersectCardinality(fixedBitSet) != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Units.Type getUnits() {
        return this.spTree.getUnits();
    }

    @Override
    public void setUnits(Units.Type type) {
        assert (false);
    }
}

