/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.misc.obsolete;

import dr.evomodel.antigenic.NPAntigenicLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ClusterOperator
extends SimpleMCMCOperator {
    public static final String CLUSTER_OPERATOR = "clusterOperator";
    public static final String WINDOW_SIZE = "windowSize";
    public NPAntigenicLikelihood modelLikelihood;
    private Parameter assignments = null;
    private Parameter links = null;
    private MatrixParameter virusLocations = null;
    private double windowSize = 1.0;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String ASSIGNMENTS = "assignments";
        public static final String VIRUS_LOCATIONS = "virusLocations";
        public static final String LIKELIHOOD = "likelihood";
        public static final String LINKS = "links";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule("assignments", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("virusLocations", MatrixParameter.class, "Parameter of locations of all virus"), new ElementRule("links", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("likelihood", new XMLSyntaxRule[]{new ElementRule(Likelihood.class)}, true)};

        @Override
        public String getParserName() {
            return ClusterOperator.CLUSTER_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            XMLObject xMLObject2 = xMLObject.getChild(ASSIGNMENTS);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            MatrixParameter matrixParameter = null;
            if (xMLObject.hasChildNamed(VIRUS_LOCATIONS)) {
                matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(VIRUS_LOCATIONS);
            }
            xMLObject2 = xMLObject.getChild(LINKS);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(LIKELIHOOD);
            NPAntigenicLikelihood nPAntigenicLikelihood = (NPAntigenicLikelihood)xMLObject2.getChild(NPAntigenicLikelihood.class);
            return new ClusterOperator(parameter, matrixParameter, d, 1.0, nPAntigenicLikelihood, parameter2);
        }

        @Override
        public String getParserDescription() {
            return "An operator that picks a new allocation of an item to a cluster under the Dirichlet process.";
        }

        @Override
        public Class getReturnType() {
            return ClusterOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ClusterOperator(Parameter parameter, MatrixParameter matrixParameter, double d, double d2, NPAntigenicLikelihood nPAntigenicLikelihood, Parameter parameter2) {
        this.links = parameter2;
        this.assignments = parameter;
        this.virusLocations = matrixParameter;
        this.windowSize = d2;
        this.modelLikelihood = nPAntigenicLikelihood;
        this.setWeight(d);
        System.out.println((int)parameter.getParameterValue(0));
        Parameter parameter3 = matrixParameter.getParameter(0);
    }

    @Override
    public final double doOperation() {
        double d = MathUtils.nextDouble();
        double d2 = 0.5;
        int n = this.assignments.getDimension();
        int n2 = MathUtils.nextInt(n);
        int n3 = (int)this.assignments.getParameterValue(n2);
        int n4 = MathUtils.nextInt(this.virusLocations.getParameter(0).getDimension());
        double d3 = (2.0 * MathUtils.nextDouble() - 1.0) * this.windowSize;
        for (int i = 0; i < n; ++i) {
            if ((int)this.assignments.getParameterValue(i) != n3) continue;
            Parameter parameter = this.virusLocations.getParameter(i);
            double d4 = parameter.getParameterValue(n4) + d3;
            parameter.setParameterValue(n4, d4);
        }
        return 0.0;
    }

    public int minEmpty(double[] dArray) {
        boolean bl = false;
        int n = 0;
        while (!bl) {
            if (dArray[n] == 0.0) {
                bl = true;
                continue;
            }
            if (n == dArray.length - 1) {
                bl = true;
            }
            ++n;
        }
        return n;
    }

    public int maxFull(double[] dArray) {
        boolean bl = true;
        int n = dArray.length - 1;
        while (bl) {
            if (dArray[n] != 0.0) {
                bl = false;
                continue;
            }
            --n;
        }
        return n;
    }

    public int[] connected(int n, Parameter parameter) {
        int n2 = parameter.getDimension();
        int[] nArray = new int[n2 + 1];
        nArray[0] = n + 1;
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            int n4;
            if (nArray[i] == 0) continue;
            int n5 = nArray[i] - 1;
            int n6 = (int)parameter.getParameterValue(n5);
            nArray[n3] = n6 + 1;
            ++n3;
            for (n4 = 0; n4 < n3 - 1; ++n4) {
                if (nArray[n4] != n6 + 1) continue;
                nArray[--n3] = 0;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                if ((int)parameter.getParameterValue(n4) != n5) continue;
                nArray[n3] = n4 + 1;
                ++n3;
                for (int j = 0; j < n3 - 1; ++j) {
                    if (nArray[j] != n4 + 1) continue;
                    nArray[--n3] = 0;
                }
            }
        }
        return nArray;
    }

    @Override
    public void accept(double d) {
        super.accept(d);
    }

    @Override
    public void reject() {
        super.reject();
    }

    @Override
    public final String getOperatorName() {
        return CLUSTER_OPERATOR;
    }

    public final void optimize(double d) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public boolean isOptimizing() {
        return false;
    }

    public void setOptimizing(boolean bl) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public String getPerformanceSuggestion() {
        if (this.getAcceptanceProbability() < this.getMinimumAcceptanceLevel()) {
            return "";
        }
        if (this.getAcceptanceProbability() > this.getMaximumAcceptanceLevel()) {
            return "";
        }
        return "";
    }

    public int getStepCount() {
        return 1;
    }
}

