/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.util.Transform;
import java.util.ArrayList;
import java.util.List;

public class RandomWalkOperator
extends AbstractAdaptableOperator {
    protected Parameter parameter = null;
    private double windowSize = 0.01;
    private List<Integer> updateMap = null;
    private int updateMapSize;
    private final BoundaryCondition boundaryCondition;

    public RandomWalkOperator(Parameter parameter, double d, BoundaryCondition boundaryCondition, double d2, AdaptationMode adaptationMode) {
        this(parameter, null, d, boundaryCondition, d2, adaptationMode);
    }

    public RandomWalkOperator(Parameter parameter, Parameter parameter2, double d, BoundaryCondition boundaryCondition, double d2, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.parameter = parameter;
        this.windowSize = d;
        this.boundaryCondition = boundaryCondition;
        this.setWeight(d2);
        if (parameter2 != null) {
            this.updateMap = new ArrayList<Integer>();
            for (int i = 0; i < parameter2.getDimension(); ++i) {
                if (parameter2.getParameterValue(i) != 1.0) continue;
                this.updateMap.add(i);
            }
            this.updateMapSize = this.updateMap.size();
        }
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public final double getWindowSize() {
        return this.windowSize;
    }

    public final BoundaryCondition getBoundaryCondition() {
        return this.boundaryCondition;
    }

    @Override
    public double doOperation() {
        if (this.parameter.getDimension() <= 0) {
            throw new RuntimeException("Illegal Dimension");
        }
        int n = this.updateMap == null ? MathUtils.nextInt(this.parameter.getDimension()) : this.updateMap.get(MathUtils.nextInt(this.updateMapSize));
        double d = (2.0 * MathUtils.nextDouble() - 1.0) * this.windowSize;
        double d2 = this.parameter.getParameterValue(n);
        Bounds<Double> bounds = this.parameter.getBounds();
        double d3 = bounds.getLowerLimit(n);
        double d4 = bounds.getUpperLimit(n);
        if (this.boundaryCondition == BoundaryCondition.logit) {
            double d5 = (d2 - d3) / (d4 - d3);
            double d6 = Transform.LOGIT.inverse(Transform.LOGIT.transform(d5) + d);
            this.parameter.setParameterValue(n, d6 * (d4 - d3) + d3);
            return Transform.LOGIT.getLogJacobian(d5) - Transform.LOGIT.getLogJacobian(d6);
        }
        if (this.boundaryCondition == BoundaryCondition.log) {
            double d7 = d2 - d3;
            double d8 = Transform.LOG.inverse(Transform.LOG.transform(d7) + d);
            this.parameter.setParameterValue(n, d8 + d3);
            return Transform.LOG.getLogJacobian(d7) - Transform.LOG.getLogJacobian(d8);
        }
        double d9 = d2 + d;
        if (this.boundaryCondition == BoundaryCondition.reflecting) {
            d9 = RandomWalkOperator.reflectValue(d9, d3, d4);
        } else {
            if (this.boundaryCondition == BoundaryCondition.absorbing && (d9 < d3 || d9 > d4)) {
                return 0.0;
            }
            if (this.boundaryCondition == BoundaryCondition.rejecting && (d9 < d3 || d9 > d4)) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        this.parameter.setParameterValue(n, d9);
        if (this.parameter.check()) {
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public static double reflectValue(double d, double d2, double d3) {
        double d4 = d;
        if (d3 == d2) {
            d4 = d3;
        } else if (d < d2) {
            if (Double.isInfinite(d3)) {
                d4 = d2 + (d2 - d);
            } else {
                double d5 = (d2 - d) / (d3 - d2);
                double d6 = Math.floor(d5);
                double d7 = (d5 - d6) * (d3 - d2);
                d4 = d6 % 2.0 == 0.0 ? d2 + d7 : d3 - d7;
            }
        } else if (d > d3) {
            if (Double.isInfinite(d2)) {
                d4 = d3 - (d4 - d3);
            } else {
                double d8 = (d - d3) / (d3 - d2);
                double d9 = Math.floor(d8);
                double d10 = (d8 - d9) * (d3 - d2);
                d4 = d9 % 2.0 == 0.0 ? d3 - d10 : d2 + d10;
            }
        }
        return d4;
    }

    public double reflectValueLoop(double d, double d2, double d3) {
        double d4 = d;
        while (d4 < d2 || d4 > d3) {
            if (d4 < d2) {
                d4 = d2 + (d2 - d4);
            }
            if (!(d4 > d3)) continue;
            d4 = d3 - (d4 - d3);
        }
        return d4;
    }

    @Override
    public final String getOperatorName() {
        return this.parameter.getParameterName();
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.windowSize);
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
        this.windowSize = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.windowSize;
    }

    @Override
    public String getAdaptableParameterName() {
        return "windowSize";
    }

    public String toString() {
        return "randomWalkOperator(" + this.parameter.getParameterName() + ", " + this.windowSize + ", " + this.getWeight() + ")";
    }

    public static enum BoundaryCondition {
        rejecting,
        reflecting,
        absorbing,
        log,
        logit;

    }
}

