/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

public enum TraceType {
    REAL("real", "R", Double.class),
    INTEGER("integer", "I", Integer.class),
    CATEGORICAL("categorical", "C", String.class),
    BINARY("binary", "B", Integer.class);

    private final String name;
    private final String brief;
    private final Class type;

    private TraceType(String string2, String string3, Class clazz) {
        this.name = string2;
        this.brief = string3;
        this.type = clazz;
    }

    public String toString() {
        return this.name;
    }

    public String getBrief() {
        return this.brief;
    }

    private Class getTypeClass() {
        return this.type;
    }

    public boolean isContinuous() {
        return this.getTypeClass() == Double.class;
    }

    public boolean isNumber() {
        return this.getTypeClass() == Double.class || this.getTypeClass() == Integer.class;
    }

    public boolean isInteger() {
        return this.getTypeClass() == Integer.class;
    }

    public boolean isDiscrete() {
        return this.isInteger() || this.isCategorical();
    }

    public boolean isBinary() {
        return this == BINARY;
    }

    public boolean isIntegerOrBinary() {
        return this.isInteger() || this.isBinary();
    }

    public boolean isCategorical() {
        return this.getTypeClass() == String.class;
    }
}

