/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.datatype.DataType;
import dr.evolution.util.TaxonList;
import dr.util.Identifiable;

public interface PatternList
extends TaxonList,
Identifiable {
    public int getPatternCount();

    public int getStateCount();

    public int getPatternLength();

    public int[] getPattern(int var1);

    public int getPatternIndex(int var1);

    public double[][] getUncertainPattern(int var1);

    public int getPatternState(int var1, int var2);

    public double[] getUncertainPatternState(int var1, int var2);

    public double getPatternWeight(int var1);

    public double[] getPatternWeights();

    public DataType getDataType();

    public double[] getStateFrequencies();

    public boolean areUnique();

    public boolean areUncertain();

    public static class Utils {
        public static double[] empiricalStateFrequencies(PatternList patternList) {
            return Utils.empiricalStateFrequenciesPAUP(patternList);
        }

        public static double[] empiricalStateFrequenciesPAUP(PatternList patternList) {
            double d;
            DataType dataType = patternList.getDataType();
            int n = patternList.getStateCount();
            int n2 = patternList.getPatternLength();
            int n3 = patternList.getPatternCount();
            double[] dArray = Utils.equalStateFrequencies(patternList);
            double[] dArray2 = new double[n];
            int n4 = 0;
            do {
                int n5;
                for (n5 = 0; n5 < n; ++n5) {
                    dArray2[n5] = 0.0;
                }
                double d2 = 0.0;
                for (n5 = 0; n5 < n3; ++n5) {
                    int[] nArray = patternList.getPattern(n5);
                    double d3 = patternList.getPatternWeight(n5);
                    for (int i = 0; i < n2; ++i) {
                        int n6;
                        boolean[] blArray = dataType.getStateSet(nArray[i]);
                        double d4 = 0.0;
                        for (n6 = 0; n6 < n; ++n6) {
                            if (!blArray[n6]) continue;
                            d4 += dArray[n6];
                        }
                        for (n6 = 0; n6 < n; ++n6) {
                            if (!blArray[n6]) continue;
                            double d5 = dArray[n6] * d3 / d4;
                            int n7 = n6;
                            dArray2[n7] = dArray2[n7] + d5;
                            d2 += d5;
                        }
                    }
                }
                d = 0.0;
                for (n5 = 0; n5 < n; ++n5) {
                    d += Math.abs(dArray2[n5] / d2 - dArray[n5]);
                    dArray[n5] = dArray2[n5] / d2;
                }
            } while (d > 1.0E-8 && ++n4 < 1000);
            return dArray;
        }

        public static double[] empiricalStateFrequenciesMrBayes(PatternList patternList) {
            int n;
            DataType dataType = patternList.getDataType();
            int n2 = patternList.getStateCount();
            int n3 = patternList.getPatternLength();
            int n4 = patternList.getPatternCount();
            double[] dArray = Utils.equalStateFrequencies(patternList);
            double d = 0.0;
            double[] dArray2 = new double[n2];
            for (n = 0; n < n4; ++n) {
                int[] nArray = patternList.getPattern(n);
                double d2 = patternList.getPatternWeight(n);
                for (int i = 0; i < n3; ++i) {
                    int n5;
                    boolean[] blArray = dataType.getStateSet(nArray[i]);
                    double d3 = 0.0;
                    for (n5 = 0; n5 < n2; ++n5) {
                        if (!blArray[n5]) continue;
                        d3 += dArray[n5];
                    }
                    for (n5 = 0; n5 < n2; ++n5) {
                        if (!blArray[n5]) continue;
                        double d4 = dArray[n5] * d2 / d3;
                        int n6 = n5;
                        dArray2[n6] = dArray2[n6] + d4;
                        d += d4;
                    }
                }
            }
            for (n = 0; n < n2; ++n) {
                dArray[n] = dArray2[n] / d;
            }
            return dArray;
        }

        public static double[] equalStateFrequencies(PatternList patternList) {
            int n = patternList.getStateCount();
            double[] dArray = new double[n];
            double d = 1.0 / (double)n;
            for (int i = 0; i < n; ++i) {
                dArray[i] = d;
            }
            return dArray;
        }
    }
}

