/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.continuous.DiffusionModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class SimulateTrait {
    public static final String SIMULATE_TRAIT = "traitTree";
    public static final String TRAIT_NAME = "traitName";
    public static final String CLONE = "clone";
    public static final String INITIAL_VALUE = "initialValue";
    public static final String MODEL = "model";
    public static final String TREE = "tree";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("traitName", "The name to be given to the trait to be simulated"), AttributeRule.newBooleanRule("clone"), AttributeRule.newDoubleRule("initialValue"), new ElementRule(DiffusionModel.class), new ElementRule(Tree.class)};

        @Override
        public String getParserName() {
            return SimulateTrait.SIMULATE_TRAIT;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute(SimulateTrait.TRAIT_NAME);
            boolean bl = xMLObject.getBooleanAttribute(SimulateTrait.CLONE);
            double d = xMLObject.getDoubleAttribute(SimulateTrait.INITIAL_VALUE);
            DiffusionModel diffusionModel = (DiffusionModel)xMLObject.getChild(DiffusionModel.class);
            Tree tree = (Tree)xMLObject.getChild(Tree.class);
            SimulateTrait simulateTrait = new SimulateTrait(diffusionModel, string);
            Tree tree2 = simulateTrait.simulate(tree, d, bl);
            return tree2;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Simulates a trait on a tree";
        }

        @Override
        public Class getReturnType() {
            return Tree.class;
        }
    };
    DiffusionModel diffusionModel = null;
    String traitName = null;

    public SimulateTrait(DiffusionModel diffusionModel, String string) {
        this.diffusionModel = diffusionModel;
        this.traitName = string;
    }

    public Tree simulate(Tree tree, double d, boolean bl) {
        Tree tree2 = null;
        if (bl) {
            tree2 = new FlexibleTree(tree);
            ((FlexibleTree)tree2).resolveTree();
        } else {
            tree2 = tree;
        }
        this.simulate((MutableTree)tree2, tree2.getRoot(), d);
        return tree2;
    }

    private void simulate(MutableTree mutableTree, NodeRef nodeRef, double d) {
        mutableTree.setNodeAttribute(nodeRef, this.traitName, new Double(d));
        int n = mutableTree.getChildCount(nodeRef);
        double d2 = mutableTree.getNodeHeight(nodeRef);
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef2 = mutableTree.getChild(nodeRef, i);
            this.simulate(mutableTree, nodeRef2, this.diffusionModel.simulateForward(d, d2 - mutableTree.getNodeHeight(nodeRef2)));
        }
    }
}

