/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.epidemiology.casetocase.AbstractCase;
import dr.evomodel.epidemiology.casetocase.BranchMapModel;
import dr.evomodel.epidemiology.casetocase.CaseToCaseTreeLikelihood;
import dr.evomodel.epidemiology.casetocase.PartitionedTreeModel;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.HashSet;

public class TransmissionWilsonBaldingA
extends AbstractTreeOperator {
    private final CaseToCaseTreeLikelihood c2cLikelihood;
    public static final String TRANSMISSION_WILSON_BALDING_A = "transmissionWilsonBaldingA";
    private double logq;
    private static final boolean DEBUG = false;
    private final int tipCount;
    private final boolean resampleInfectionTimes;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String RESAMPLE_INFECTION_TIMES = "resampleInfectionTimes";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newBooleanRule("resampleInfectionTimes", true), new ElementRule(CaseToCaseTreeLikelihood.class)};

        @Override
        public String getParserName() {
            return TransmissionWilsonBaldingA.TRANSMISSION_WILSON_BALDING_A;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            CaseToCaseTreeLikelihood caseToCaseTreeLikelihood = (CaseToCaseTreeLikelihood)xMLObject.getChild(CaseToCaseTreeLikelihood.class);
            double d = xMLObject.getDoubleAttribute("weight");
            boolean bl = false;
            if (xMLObject.hasAttribute(RESAMPLE_INFECTION_TIMES)) {
                bl = xMLObject.getBooleanAttribute(RESAMPLE_INFECTION_TIMES);
            }
            return new TransmissionWilsonBaldingA(caseToCaseTreeLikelihood, d, bl);
        }

        @Override
        public String getParserDescription() {
            return "This element represents a Wilson-Balding move operator, such that the transplantation of the subtree does not affect the topology of the transmission tree.";
        }

        @Override
        public Class getReturnType() {
            return TransmissionWilsonBaldingA.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public TransmissionWilsonBaldingA(CaseToCaseTreeLikelihood caseToCaseTreeLikelihood, double d, boolean bl) {
        this.c2cLikelihood = caseToCaseTreeLikelihood;
        this.setWeight(d);
        this.tipCount = caseToCaseTreeLikelihood.getTreeModel().getExternalNodeCount();
        this.resampleInfectionTimes = bl;
    }

    @Override
    public double doOperation() {
        this.proposeTree();
        if (this.c2cLikelihood.getTreeModel().getExternalNodeCount() != this.tipCount) {
            int n = this.c2cLikelihood.getTreeModel().getExternalNodeCount();
            throw new RuntimeException("Lost some tips in modified SPR! (" + this.tipCount + "-> " + n + ")");
        }
        return this.logq;
    }

    public void proposeTree() {
        PartitionedTreeModel partitionedTreeModel = this.c2cLikelihood.getTreeModel();
        BranchMapModel branchMapModel = this.c2cLikelihood.getBranchMap();
        ArrayList<NodeRef> arrayList = this.getEligibleNodes(partitionedTreeModel, branchMapModel);
        NodeRef nodeRef = arrayList.get(MathUtils.nextInt(arrayList.size()));
        double d = arrayList.size();
        NodeRef nodeRef2 = partitionedTreeModel.getParent(nodeRef);
        Integer[] integerArray = partitionedTreeModel.samePartitionElement(nodeRef2);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Integer serializable2 : integerArray) {
            hashSet.add(serializable2);
            if (partitionedTreeModel.isExternal(partitionedTreeModel.getNode(serializable2))) continue;
            hashSet.add(partitionedTreeModel.getChild(partitionedTreeModel.getNode(serializable2), 0).getNumber());
            hashSet.add(partitionedTreeModel.getChild(partitionedTreeModel.getNode(serializable2), 1).getNumber());
        }
        Integer[] integerArray2 = hashSet.toArray(new Integer[hashSet.size()]);
        NodeRef nodeRef3 = partitionedTreeModel.getNode(integerArray2[MathUtils.nextInt(integerArray2.length)]);
        NodeRef nodeRef4 = partitionedTreeModel.getParent(nodeRef3);
        while (nodeRef4 != null && partitionedTreeModel.getNodeHeight(nodeRef4) <= partitionedTreeModel.getNodeHeight(nodeRef) || nodeRef == nodeRef3) {
            nodeRef3 = partitionedTreeModel.getNode(integerArray2[MathUtils.nextInt(integerArray2.length)]);
            nodeRef4 = partitionedTreeModel.getParent(nodeRef3);
        }
        if (nodeRef2 == partitionedTreeModel.getRoot() || nodeRef3 == partitionedTreeModel.getRoot()) {
            this.logq = Double.NEGATIVE_INFINITY;
            return;
        }
        if (nodeRef4 == nodeRef2 || nodeRef3 == nodeRef2 || nodeRef4 == nodeRef) {
            this.logq = Double.NEGATIVE_INFINITY;
            return;
        }
        NodeRef nodeRef5 = this.getOtherChild(partitionedTreeModel, nodeRef2, nodeRef);
        NodeRef nodeRef6 = partitionedTreeModel.getParent(nodeRef2);
        if (this.resampleInfectionTimes) {
            AbstractCase d8 = branchMapModel.get(nodeRef.getNumber());
            AbstractCase abstractCase = branchMapModel.get(nodeRef2.getNumber());
            AbstractCase abstractCase2 = branchMapModel.get(nodeRef5.getNumber());
            AbstractCase abstractCase3 = null;
            if (nodeRef6 != null) {
                abstractCase3 = branchMapModel.get(nodeRef6.getNumber());
            }
            if (d8 != abstractCase) {
                d8.setInfectionBranchPosition(MathUtils.nextDouble());
            }
            if (abstractCase3 == null || abstractCase2 != abstractCase3) {
                abstractCase2.setInfectionBranchPosition(MathUtils.nextDouble());
            }
            AbstractCase abstractCase4 = branchMapModel.get(nodeRef3.getNumber());
            AbstractCase abstractCase5 = branchMapModel.get(nodeRef4.getNumber());
            if (abstractCase != abstractCase4 && abstractCase != abstractCase5) {
                throw new RuntimeException("TWBA misbehaving.");
            }
            abstractCase4.setInfectionBranchPosition(MathUtils.nextDouble());
        }
        double d2 = Math.max(partitionedTreeModel.getNodeHeight(nodeRef), partitionedTreeModel.getNodeHeight(nodeRef3));
        double d3 = partitionedTreeModel.getNodeHeight(nodeRef4) - d2;
        double d4 = d2 + MathUtils.nextDouble() * d3;
        double d5 = Math.max(partitionedTreeModel.getNodeHeight(nodeRef), partitionedTreeModel.getNodeHeight(nodeRef5));
        double d6 = partitionedTreeModel.getNodeHeight(nodeRef6) - d5;
        double d7 = d3 / Math.abs(d6);
        partitionedTreeModel.beginTreeEdit();
        if (nodeRef3 == partitionedTreeModel.getRoot()) {
            partitionedTreeModel.removeChild(nodeRef2, nodeRef5);
            partitionedTreeModel.removeChild(nodeRef6, nodeRef2);
            partitionedTreeModel.addChild(nodeRef2, nodeRef3);
            partitionedTreeModel.addChild(nodeRef6, nodeRef5);
            partitionedTreeModel.setRoot(nodeRef2);
        } else if (nodeRef2 == partitionedTreeModel.getRoot()) {
            partitionedTreeModel.removeChild(nodeRef4, nodeRef3);
            partitionedTreeModel.removeChild(nodeRef2, nodeRef5);
            partitionedTreeModel.addChild(nodeRef2, nodeRef3);
            partitionedTreeModel.addChild(nodeRef4, nodeRef2);
            partitionedTreeModel.setRoot(nodeRef5);
        } else {
            partitionedTreeModel.removeChild(nodeRef4, nodeRef3);
            partitionedTreeModel.removeChild(nodeRef2, nodeRef5);
            partitionedTreeModel.removeChild(nodeRef6, nodeRef2);
            partitionedTreeModel.addChild(nodeRef2, nodeRef3);
            partitionedTreeModel.addChild(nodeRef4, nodeRef2);
            partitionedTreeModel.addChild(nodeRef6, nodeRef5);
        }
        partitionedTreeModel.setNodeHeight(nodeRef2, d4);
        partitionedTreeModel.endTreeEdit();
        this.logq = Math.log(d7);
        double d8 = this.getEligibleNodes(partitionedTreeModel, branchMapModel).size();
        this.logq += Math.log(d / d8);
    }

    public String getPerformanceSuggestion() {
        return "Not implemented";
    }

    private boolean eligibleForMove(NodeRef nodeRef, TreeModel treeModel, BranchMapModel branchMapModel) {
        return !treeModel.isRoot(nodeRef) && (treeModel.getParent(treeModel.getParent(nodeRef)) != null && branchMapModel.get(treeModel.getParent(nodeRef).getNumber()) == branchMapModel.get(treeModel.getParent(treeModel.getParent(nodeRef)).getNumber()) || branchMapModel.get(treeModel.getParent(nodeRef).getNumber()) == branchMapModel.get(this.getOtherChild(treeModel, treeModel.getParent(nodeRef), nodeRef).getNumber()));
    }

    private ArrayList<NodeRef> getEligibleNodes(TreeModel treeModel, BranchMapModel branchMapModel) {
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        for (NodeRef nodeRef : treeModel.getNodes()) {
            if (!this.eligibleForMove(nodeRef, treeModel, branchMapModel)) continue;
            arrayList.add(nodeRef);
        }
        return arrayList;
    }

    @Override
    public String getOperatorName() {
        return "transmissionWilsonBaldingA (" + this.c2cLikelihood.getTreeModel().getId() + ")";
    }
}

