/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.stuff;

import dr.evomodel.branchmodel.lineagespecific.CountableRealizationsParameter;
import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class GenPolyaUrnProcessPrior
extends AbstractModelLikelihood {
    private static boolean VERBOSE = false;
    public Parameter groupAssignments;
    public Parameter categoriesParameter;
    public CompoundParameter uniquelyRealizedParameters;
    public CountableRealizationsParameter allParameters;
    public CompoundParameter tableCounts;
    public CompoundParameter stickProportions;
    public List<ParametricMultivariateDistributionModel> baseDistributionList;
    public List<ParametricMultivariateDistributionModel> commonBaseDistBaseDist;
    public List<Parameter> massParameterList;
    public List<Parameter> dpConcentrations;
    public Parameter commonBaseDistMass;
    public int maxCategoryCount;
    public int maxGroupCount;
    public int numStartingCategories;
    public int N;
    public boolean likelihoodKnown = false;
    public double logLikelihood;
    public final List<Double> cachedLogFactorials;
    protected boolean isIHMM;
    protected boolean isHMM;
    protected int[] isCatActive;
    protected boolean isCatActiveKnown = false;
    public static final double ACCURACY_THRESHOLD = 1.0E-12;

    public GenPolyaUrnProcessPrior(Parameter parameter, Parameter parameter2, CompoundParameter compoundParameter, CountableRealizationsParameter countableRealizationsParameter, List<ParametricMultivariateDistributionModel> list, List<Parameter> list2, List<Parameter> list3, List<ParametricMultivariateDistributionModel> list4, Parameter parameter3, int n, int n2, CompoundParameter compoundParameter2, CompoundParameter compoundParameter3, boolean bl, boolean bl2) {
        super("");
        this.isIHMM = bl;
        this.categoriesParameter = parameter2;
        this.tableCounts = compoundParameter2;
        this.stickProportions = compoundParameter3;
        this.uniquelyRealizedParameters = compoundParameter;
        this.allParameters = countableRealizationsParameter;
        this.dpConcentrations = list3;
        this.maxCategoryCount = n2;
        this.maxGroupCount = n;
        if (this.maxCategoryCount != this.uniquelyRealizedParameters.getParameterCount()) {
            throw new RuntimeException("cannot have maxCategoryCount unequal to uniquelyRealizedParameters dimension");
        }
        this.baseDistributionList = list == null ? this.setUpBaseDistributionList() : list;
        this.commonBaseDistBaseDist = list4;
        this.commonBaseDistMass = parameter3;
        this.massParameterList = list2 == null ? this.setUpMassParameterList() : list2;
        this.groupAssignments = parameter;
        this.computeGroupAssignments(this.categoriesParameter);
        this.N = this.groupAssignments.getDimension();
        this.cachedLogFactorials = new ArrayList<Double>();
        this.cachedLogFactorials.add(0, 0.0);
        this.addVariable(this.groupAssignments);
        this.addVariable(this.categoriesParameter);
        if (this.tableCounts != null && this.stickProportions != null) {
            this.setUpInitialValuesForHDP();
            this.addVariable(this.tableCounts);
            this.addVariable(this.stickProportions);
        }
        this.addVariable(this.uniquelyRealizedParameters);
        if (this.baseDistributionList != null) {
            for (ParametricMultivariateDistributionModel identifiable : this.baseDistributionList) {
                this.addModel(identifiable);
            }
        }
        for (Parameter parameter4 : this.massParameterList) {
            this.addVariable(parameter4);
        }
        if (this.commonBaseDistBaseDist != null) {
            for (ParametricMultivariateDistributionModel parametricMultivariateDistributionModel : this.commonBaseDistBaseDist) {
                this.addModel(parametricMultivariateDistributionModel);
            }
        }
        if (this.commonBaseDistMass != null) {
            this.addVariable(this.commonBaseDistMass);
        }
        this.likelihoodKnown = false;
        this.isCatActive = new int[parameter2.getSize()];
        this.updateIsCatActive();
        this.isCatActiveKnown = true;
    }

    public List<ParametricMultivariateDistributionModel> setUpBaseDistributionList() {
        return null;
    }

    public List<Parameter> setUpMassParameterList() {
        return null;
    }

    public void setUpInitialValuesForHDP() {
    }

    public void updateIsCatActive() {
        int[][] nArray = this.getCounts();
        Arrays.fill(this.isCatActive, 0);
        for (int i = 0; i < this.maxGroupCount; ++i) {
            for (int j = 0; j < this.maxCategoryCount; ++j) {
                if (nArray[i][j] <= 0) continue;
                this.isCatActive[j] = 1;
            }
        }
    }

    public void computeGroupAssignments(Parameter parameter) {
        for (int i = 0; i < this.groupAssignments.getSize(); ++i) {
            this.groupAssignments.setParameterValue(i, 0.0);
        }
    }

    public void setGroup(Parameter parameter, int n, int n2) {
        parameter.setParameterValue(n, 0.0);
    }

    public double getLogFactorial(int n) {
        if (this.cachedLogFactorials.size() <= n) {
            for (int i = this.cachedLogFactorials.size() - 1; i <= n; ++i) {
                double d = this.cachedLogFactorials.get(i) + Math.log(i + 1);
                this.cachedLogFactorials.add(d);
            }
        }
        return this.cachedLogFactorials.get(n);
    }

    public int[][] getCounts() {
        int[][] nArray = new int[this.maxGroupCount][this.maxCategoryCount];
        for (int i = 0; i < this.N; ++i) {
            int n = (int)this.groupAssignments.getParameterValue(i);
            int n2 = (int)this.categoriesParameter.getParameterValue(i);
            int[] nArray2 = nArray[n];
            int n3 = n2;
            nArray2[n3] = nArray2[n3] + 1;
        }
        return nArray;
    }

    public double getMassParam(int n) {
        return this.massParameterList.get(n).getParameterValue(0);
    }

    public int getOrder() {
        return 0;
    }

    public boolean isFinite() {
        return false;
    }

    public boolean isHMM() {
        return this.isHMM;
    }

    public int getGroupAssignment(int n) {
        return 1;
    }

    public Parameter getGroupAssignments() {
        return this.groupAssignments;
    }

    public Parameter getCategoriesParameter() {
        return this.categoriesParameter;
    }

    public CompoundParameter getUniquelyRealizedParameters() {
        return this.uniquelyRealizedParameters;
    }

    public int[] getIsCatActive() {
        if (this.isCatActiveKnown) {
            return this.isCatActive;
        }
        this.updateIsCatActive();
        return this.isCatActive;
    }

    public CountableRealizationsParameter getAllParameters() {
        return this.allParameters;
    }

    public List<Parameter> getMassParameterList() {
        return this.massParameterList;
    }

    public List<ParametricMultivariateDistributionModel> getBaseDistributionList() {
        return this.baseDistributionList;
    }

    public CompoundParameter getTableCounts() {
        return this.tableCounts;
    }

    public CompoundParameter getStickProportions() {
        return this.stickProportions;
    }

    public Parameter getCommonMass() {
        return this.massParameterList.get(0);
    }

    public Parameter getCommonBaseDistMass() {
        return this.commonBaseDistMass;
    }

    public List<ParametricMultivariateDistributionModel> getCommonBaseDistBaseDist() {
        return this.commonBaseDistBaseDist;
    }

    public List<ParametricMultivariateDistributionModel> getParametricBaseDist() {
        if (this.isIHMM) {
            return this.commonBaseDistBaseDist;
        }
        return this.baseDistributionList;
    }

    public double getLogDensity(Parameter parameter, int n) {
        double[] dArray = parameter.getParameterValues();
        double d = 0.0;
        int n2 = this.baseDistributionList.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.baseDistributionList.get(i).getDimension();
            double[] dArray2 = new double[n4];
            for (int j = 0; j < n4; ++j) {
                dArray2[j] = dArray[n3];
                ++n3;
            }
            d += this.baseDistributionList.get(i).logPdf(dArray2);
        }
        return d;
    }

    public double getSingletonProbability(Parameter parameter, List<ParametricMultivariateDistributionModel> list, int n) {
        return 0.0;
    }

    public double getLogGammaRatio(int n, int n2, int n3) {
        return this.getLogFactorial(n - 1);
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        this.fireModelChanged();
        this.likelihoodKnown = false;
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    public double calculateLogLikelihood() {
        int[][] nArray = this.getCounts();
        Arrays.fill(this.isCatActive, 0);
        int[] nArray2 = new int[this.maxGroupCount];
        double d = 0.0;
        for (int i = 0; i < this.maxGroupCount; ++i) {
            int n;
            int n2 = 0;
            nArray2[i] = 0;
            for (n = 0; n < this.maxCategoryCount; ++n) {
                n2 += nArray[i][n];
                if (nArray[i][n] <= 0) continue;
                this.isCatActive[n] = 1;
                d += this.getLogGammaRatio(nArray[i][n], i, n);
                int n3 = i;
                nArray2[n3] = nArray2[n3] + 1;
                Parameter parameter = this.uniquelyRealizedParameters.getParameter(n);
                d += this.getLogDensity(parameter, i);
            }
            d += (double)nArray2[i] * Math.log(this.getMassParam(i));
            for (n = 1; n <= n2; ++n) {
                d -= Math.log(this.getMassParam(i) + (double)n - 1.0);
            }
        }
        this.isCatActiveKnown = true;
        return d;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.categoriesParameter) {
            this.isCatActiveKnown = false;
            this.fireModelChanged();
        } else if (variable == this.groupAssignments) {
            this.fireModelChanged();
        } else if (variable == this.tableCounts) {
            this.fireModelChanged();
        } else if (variable == this.stickProportions) {
            this.fireModelChanged();
        } else if (variable == this.massParameterList) {
            this.fireModelChanged();
        } else if (this.massParameterList.contains(variable)) {
            this.fireModelChanged();
        } else if (variable == this.commonBaseDistMass) {
            this.fireModelChanged();
        } else if (variable == this.uniquelyRealizedParameters) {
            this.likelihoodKnown = false;
            this.fireModelChanged();
        } else {
            System.err.println("variable name: " + variable.getVariableName());
            throw new IllegalArgumentException("Unknown parameter");
        }
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = false;
    }

    @Override
    protected void acceptState() {
    }
}

