/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evomodel.substmodel.DifferentiableSubstitutionModel;
import dr.evomodel.substmodel.DifferentiableSubstitutionModelUtil;
import dr.math.matrixAlgebra.WrappedMatrix;

public interface DifferentialMassProvider {
    public double[] getDifferentialMassMatrix(double var1);

    public static class DifferentialWrapper
    implements DifferentialMassProvider {
        private final DifferentiableSubstitutionModel baseModel;
        private final WrtParameter wrt;
        private final Mode mode;

        public DifferentialWrapper(DifferentiableSubstitutionModel differentiableSubstitutionModel, WrtParameter wrtParameter, Mode mode) {
            this.baseModel = differentiableSubstitutionModel;
            this.wrt = wrtParameter;
            this.mode = mode;
        }

        @Override
        public double[] getDifferentialMassMatrix(double d) {
            return this.mode.dispatch(d, this.baseModel, this.baseModel.getInfinitesimalDifferentialMatrix(this.wrt));
        }

        public static interface WrtParameter {
            public double getRate(int var1);

            public double getNormalizationDifferential();

            public void setupDifferentialFrequencies(double[] var1, double[] var2);

            public void setupDifferentialRates(double[] var1, double[] var2, double var3);
        }
    }

    public static enum Mode {
        EXACT("exact"){

            @Override
            public double[] dispatch(double d, DifferentiableSubstitutionModel differentiableSubstitutionModel, WrappedMatrix wrappedMatrix) {
                return DifferentiableSubstitutionModelUtil.getExactDifferentialMassMatrix(d, wrappedMatrix, differentiableSubstitutionModel.getEigenDecomposition());
            }

            @Override
            public String getReport() {
                return "Exact";
            }
        }
        ,
        FIRST_ORDER("firstOrder"){

            @Override
            public double[] dispatch(double d, DifferentiableSubstitutionModel differentiableSubstitutionModel, WrappedMatrix wrappedMatrix) {
                return DifferentiableSubstitutionModelUtil.getApproximateDifferentialMassMatrix(d, wrappedMatrix);
            }

            @Override
            public String getReport() {
                return "Approximate wrt parameter";
            }
        }
        ,
        AFFINE("affineCorrected"){

            @Override
            public double[] dispatch(double d, DifferentiableSubstitutionModel differentiableSubstitutionModel, WrappedMatrix wrappedMatrix) {
                return DifferentiableSubstitutionModelUtil.getAffineDifferentialMassMatrix(d, wrappedMatrix, differentiableSubstitutionModel.getEigenDecomposition());
            }

            @Override
            public String getReport() {
                return "Affine-corrected wrt parameter";
            }
        };

        private final String label;

        private Mode(String string2) {
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }

        public abstract double[] dispatch(double var1, DifferentiableSubstitutionModel var3, WrappedMatrix var4);

        public abstract String getReport();

        public static Mode parse(String string) {
            for (Mode mode : Mode.values()) {
                if (!mode.label.equalsIgnoreCase(string)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Unknown mode");
        }
    }
}

