/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.inference.loggers.LogColumn;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public interface LogAdditiveCtmcRateProvider
extends Model,
Likelihood {
    public double[] getXBeta();

    public Parameter getLogRateParameter();

    @Override
    public LogColumn[] getColumns();

    default public double[] getRates() {
        double[] dArray = this.getXBeta();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.exp(dArray[i]);
        }
        return dArray;
    }

    public static interface DataAugmented
    extends LogAdditiveCtmcRateProvider {
        @Override
        public Parameter getLogRateParameter();

        public static class Basic
        extends AbstractModelLikelihood
        implements DataAugmented {
            private final Parameter logRateParameter;

            public Basic(String string, Parameter parameter) {
                super(string);
                this.logRateParameter = parameter;
                this.addVariable(parameter);
            }

            @Override
            public Parameter getLogRateParameter() {
                return this.logRateParameter;
            }

            @Override
            public double[] getXBeta() {
                int n = this.logRateParameter.getDimension();
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = Math.exp(this.logRateParameter.getParameterValue(i));
                }
                return dArray;
            }

            @Override
            protected void handleModelChangedEvent(Model model, Object object, int n) {
            }

            @Override
            protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
            }

            @Override
            protected void storeState() {
            }

            @Override
            protected void restoreState() {
            }

            @Override
            protected void acceptState() {
            }

            @Override
            public Model getModel() {
                return this;
            }

            @Override
            public double getLogLikelihood() {
                return 0.0;
            }

            @Override
            public void makeDirty() {
            }
        }
    }

    public static interface Integrated
    extends LogAdditiveCtmcRateProvider {
    }
}

