/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.SpaceTimeRejector1D;
import dr.math.MathUtils;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;

public class BrownianBridge1D {
    public static List<Point2D> divideConquerBrownianBridge(double d, double d2, double d3, double d4, double d5, int n, SpaceTimeRejector1D spaceTimeRejector1D) {
        return BrownianBridge1D.divideConquerBrownianBridge(d, new Point2D.Double(d2, d3), new Point2D.Double(d4, d5), n, spaceTimeRejector1D);
    }

    public static List<Point2D> divideConquerBrownianBridge(double d, Point2D point2D, Point2D point2D2, int n, SpaceTimeRejector1D spaceTimeRejector1D) {
        LinkedList<Point2D> linkedList = new LinkedList<Point2D>();
        linkedList.add(point2D);
        linkedList.add(point2D2);
        BrownianBridge1D.divideConquerBrownianBridge(d, 0, linkedList, n, spaceTimeRejector1D);
        return linkedList;
    }

    public static int divideConquerBrownianBridge(double d, int n, List<Point2D> list, int n2, SpaceTimeRejector1D spaceTimeRejector1D) {
        if (n2 > 0) {
            Point2D point2D = list.get(n);
            Point2D point2D2 = list.get(n + 1);
            double d2 = point2D.getX();
            double d3 = point2D.getY();
            double d4 = point2D2.getX();
            double d5 = point2D2.getY();
            double d6 = (d4 - d2) / 2.0 + d2;
            double d7 = d3 + 0.5 * (d5 - d3);
            double d8 = Math.sqrt(d * (d4 - d2) / 4.0);
            double d9 = MathUtils.nextGaussian() * d8 + d7;
            if (spaceTimeRejector1D != null) {
                while (spaceTimeRejector1D.reject(d6, d9)) {
                    d9 = MathUtils.nextGaussian() * d8 + d7;
                }
            }
            list.add(n + 1, new Point2D.Double(d6, d9));
            int n3 = BrownianBridge1D.divideConquerBrownianBridge(d, n, list, n2 - 1, spaceTimeRejector1D);
            return BrownianBridge1D.divideConquerBrownianBridge(d, n3, list, n2 - 1, spaceTimeRejector1D);
        }
        return n + 1;
    }

    public static void main(String[] stringArray) {
        List<Point2D> list = BrownianBridge1D.divideConquerBrownianBridge(1.0, 0.0, 0.0, 4.0, 0.0, 5, null);
        for (Point2D point2D : list) {
            System.out.println(point2D.getX() + "\t" + point2D.getY());
        }
    }
}

