/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.evolution.tree.MutableTreeModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;

public class BitFlipOperator
extends SimpleMCMCOperator {
    private BitFlipHelper bitFlipHelper;
    private TreeModel tree;
    private TreeParameterModel indicators = null;
    private Parameter parameter = null;
    private boolean usesPriorOnSum = true;

    public BitFlipOperator(Parameter parameter, double d, boolean bl, TreeModel treeModel) {
        this.parameter = parameter;
        this.usesPriorOnSum = bl;
        if (treeModel != null) {
            this.indicators = new TreeParameterModel((MutableTreeModel)treeModel, parameter, true);
            this.bitFlipHelper = new DriftBitFlipHelper();
            this.tree = treeModel;
        } else {
            this.bitFlipHelper = new BitFlipHelper();
        }
        this.setWeight(d);
    }

    public BitFlipOperator(Parameter parameter, double d, boolean bl) {
        this(parameter, d, bl, null);
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public final double doOperation() {
        int n;
        int n2 = this.parameter.getDimension();
        double d = 0.0;
        if (this.usesPriorOnSum) {
            for (n = 0; n < n2; ++n) {
                d += Math.abs(this.parameter.getParameterValue(n));
            }
        }
        n = MathUtils.nextInt(n2);
        int n3 = (int)this.parameter.getParameterValue(n);
        double d2 = 0.0;
        if (n3 == 0) {
            d2 = this.bitFlipHelper.flipZero(n, n2, d);
        } else if (n3 == 1) {
            d2 = this.bitFlipHelper.flipOne(n, n2, d);
        } else if (n3 == -1) {
            d2 = this.bitFlipHelper.flipNegOne(n, n2, d);
        } else {
            throw new RuntimeException("expected 1 or 0 or -1");
        }
        if (!this.usesPriorOnSum) {
            d2 = 0.0;
        }
        return d2;
    }

    @Override
    public final String getOperatorName() {
        return "bitFlip(" + this.parameter.getParameterName() + ")";
    }

    public final String getPerformanceSuggestion() {
        return "no performance suggestion";
    }

    public String toString() {
        return this.getOperatorName();
    }

    class DriftBitFlipHelper
    extends BitFlipHelper {
        @Override
        public double flipOne(int n, int n2, double d) {
            double d2 = MathUtils.nextDouble();
            double d3 = 0.5 * (double)(n2 + 1) - 1.0;
            if (d2 < 0.5) {
                BitFlipOperator.this.parameter.setParameterValue(n, 0.0);
                return Math.log(2.0 * (d3 + 1.0 - d) / d);
            }
            BitFlipOperator.this.parameter.setParameterValue(n, -1.0);
            return 0.0;
        }

        @Override
        public double flipNegOne(int n, int n2, double d) {
            double d2 = MathUtils.nextDouble();
            double d3 = 0.5 * (double)(n2 + 1) - 1.0;
            if (d2 < 0.5) {
                BitFlipOperator.this.parameter.setParameterValue(n, 0.0);
                return Math.log(2.0 * (d3 + 1.0 - d) / d);
            }
            BitFlipOperator.this.parameter.setParameterValue(n, 1.0);
            return 0.0;
        }

        @Override
        public double flipZero(int n, int n2, double d) {
            int n3 = BitFlipOperator.this.indicators.getNodeNumberFromParameterIndex(n);
            if (BitFlipOperator.this.tree.isExternal(BitFlipOperator.this.tree.getNode(n3))) {
                BitFlipOperator.this.parameter.setParameterValue(n, 0.0);
                return 0.0;
            }
            double d2 = MathUtils.nextDouble();
            double d3 = 0.5 * (double)(n2 + 1) - 1.0;
            if (d2 < 0.5) {
                BitFlipOperator.this.parameter.setParameterValue(n, 1.0);
                return Math.log((d + 1.0) / (2.0 * (d3 - d)));
            }
            BitFlipOperator.this.parameter.setParameterValue(n, -1.0);
            return Math.log((d + 1.0) / (2.0 * (d3 - d)));
        }
    }

    class BitFlipHelper {
        public double flipOne(int n, int n2, double d) {
            BitFlipOperator.this.parameter.setParameterValue(n, 0.0);
            return -Math.log(d / ((double)n2 - d + 1.0));
        }

        public double flipZero(int n, int n2, double d) {
            BitFlipOperator.this.parameter.setParameterValue(n, 1.0);
            return -Math.log(((double)n2 - d) / (d + 1.0));
        }

        public double flipNegOne(int n, int n2, double d) {
            throw new RuntimeException("expected 1 or 0");
        }
    }
}

