/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import java.util.Arrays;

public class KroneckerOperation {
    public static double[] sum(double[] dArray, double[] dArray2) {
        int n = dArray.length * dArray2.length;
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = KroneckerOperation.makeIdentityVector(dArray.length);
        double[] dArray7 = KroneckerOperation.makeIdentityVector(dArray2.length);
        KroneckerOperation.sum(dArray, dArray2, dArray6, dArray7, dArray4, dArray5, dArray3);
        return dArray3;
    }

    public static void sum(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7) {
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = n * n2;
        if (dArray7.length != n3 || dArray3.length != n || dArray4.length != n2 || dArray5.length != n3 || dArray6.length != n3) {
            throw new RuntimeException("Wrong dimensions in Kronecker sum");
        }
        KroneckerOperation.product(dArray, n, 1, dArray4, n2, 1, dArray5);
        KroneckerOperation.product(dArray3, n, 1, dArray2, n2, 1, dArray6);
        for (int i = 0; i < n3; ++i) {
            dArray7[i] = dArray5[i] + dArray6[i];
        }
    }

    public static double[] sum(double[] dArray, int n, double[] dArray2, int n2) {
        int n3 = n * n2;
        double[] dArray3 = new double[n3 * n3];
        double[] dArray4 = new double[n3 * n3];
        double[] dArray5 = new double[n3 * n3];
        double[] dArray6 = KroneckerOperation.makeIdentityMatrix(n);
        double[] dArray7 = KroneckerOperation.makeIdentityMatrix(n2);
        KroneckerOperation.sum(dArray, n, dArray2, n2, dArray6, dArray7, dArray4, dArray5, dArray3);
        return dArray3;
    }

    public static void sum(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7) {
        int n3 = n * n2;
        if (dArray7.length != n3 * n3 || dArray.length != n * n || dArray2.length != n2 * n2 || dArray3.length != n * n || dArray4.length != n2 * n2 || dArray5.length != n3 * n3 || dArray6.length != n3 * n3) {
            throw new RuntimeException("Wrong dimensions in Kronecker sum");
        }
        KroneckerOperation.product(dArray, n, n, dArray4, n2, n2, dArray5);
        KroneckerOperation.product(dArray3, n, n, dArray2, n2, n2, dArray6);
        for (int i = 0; i < n3 * n3; ++i) {
            dArray7[i] = dArray5[i] + dArray6[i];
        }
    }

    public static double[] makeIdentityMatrix(int n) {
        double[] dArray = new double[n * n];
        KroneckerOperation.makeIdentityMatrix(n, dArray);
        return dArray;
    }

    public static void makeIdentityMatrix(int n, double[] dArray) {
        for (int i = 0; i < n; ++i) {
            dArray[i * n + i] = 1.0;
        }
    }

    public static double[][] makeIdentityMatrixArray(int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
        }
        return dArray;
    }

    private static double[] makeIdentityVector(int n) {
        double[] dArray = new double[n];
        Arrays.fill(dArray, 1.0);
        return dArray;
    }

    public static double[][] sum(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = n * n2;
        double[][] dArray3 = new double[n3][n3];
        double[][] dArray4 = new double[n3][n3];
        double[][] dArray5 = new double[n3][n3];
        double[][] dArray6 = KroneckerOperation.makeIdentityMatrixArray(n);
        double[][] dArray7 = KroneckerOperation.makeIdentityMatrixArray(n2);
        KroneckerOperation.sum(dArray, dArray2, dArray6, dArray7, dArray4, dArray5, dArray3);
        return dArray3;
    }

    public static void sum(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6, double[][] dArray7) {
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = n * n2;
        if (dArray7.length != n3 || dArray7[0].length != n3 || dArray[0].length != n || dArray2[0].length != n2 || dArray3.length != n || dArray3[0].length != n || dArray4.length != n2 || dArray4[0].length != n2 || dArray5.length != n3 || dArray5[0].length != n3 || dArray6.length != n3 || dArray6[0].length != n3) {
            throw new RuntimeException("Wrong dimensions in Kronecker sum");
        }
        KroneckerOperation.product(dArray, dArray4, dArray5);
        KroneckerOperation.product(dArray3, dArray2, dArray6);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                dArray7[i][j] = dArray5[i][j] + dArray6[i][j];
            }
        }
    }

    public static double[] product(double[] dArray, int n, int n2, double[] dArray2, int n3, int n4) {
        double[] dArray3 = new double[n * n3 * n2 * n4];
        KroneckerOperation.product(dArray, n, n2, dArray2, n3, n4, dArray3);
        return dArray3;
    }

    public static void product(double[] dArray, int n, int n2, double[] dArray2, int n3, int n4, double[] dArray3) {
        int n5 = n * n3;
        int n6 = n2 * n4;
        if (dArray3.length != n5 * n6 || dArray.length != n * n2 || dArray2.length != n3 * n4) {
            throw new RuntimeException("Wrong dimensions in Kronecker product");
        }
        for (int i = 0; i < n; ++i) {
            int n7 = i * n3;
            for (int j = 0; j < n2; ++j) {
                int n8 = j * n4;
                double d = dArray[i * n2 + j];
                for (int k = 0; k < n3; ++k) {
                    for (int i2 = 0; i2 < n4; ++i2) {
                        dArray3[(n7 + k) * n6 + n8 + i2] = d * dArray2[k * n4 + i2];
                    }
                }
            }
        }
    }

    public static double[][] product(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray2.length;
        int n4 = dArray2[0].length;
        double[][] dArray3 = new double[n * n3][n2 * n4];
        KroneckerOperation.product(dArray, dArray2, dArray3);
        return dArray3;
    }

    public static void product(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray2.length;
        int n4 = dArray2[0].length;
        if (dArray3 == null || dArray3.length != n * n3 || dArray3[0].length != n2 * n4) {
            throw new RuntimeException("Wrong dimensions in Kronecker product");
        }
        for (int i = 0; i < n; ++i) {
            int n5 = i * n3;
            for (int j = 0; j < n2; ++j) {
                int n6 = j * n4;
                double d = dArray[i][j];
                for (int k = 0; k < n3; ++k) {
                    for (int i2 = 0; i2 < n4; ++i2) {
                        dArray3[n5 + k][n6 + i2] = d * dArray2[k][i2];
                    }
                }
            }
        }
    }

    public static double[] vectorize(double[][] dArray) {
        double[] dArray2 = new double[dArray.length * dArray[0].length];
        KroneckerOperation.vectorize(dArray, dArray2);
        return dArray2;
    }

    public static void vectorize(double[][] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (dArray2 == null || dArray2.length != n * n2) {
            throw new RuntimeException("Wrong dimensions in vectorize");
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[n3] = dArray[i][j];
                ++n3;
            }
        }
    }
}

