/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.lineage;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.alignment.SiteList;
import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.util.XHTMLable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LineageSitePatterns
extends AbstractModel
implements SiteList,
XHTMLable {
    public static final String LINEAGE_PATTERNS = "LineagePatterns";
    protected SiteList siteList = null;
    protected int siteCount = 0;
    protected int patternCount = 0;
    protected int patternLength = 0;
    protected int[] sitePatternIndices;
    protected int invariantCount;
    protected double[] weights;
    protected int[][] patterns;
    protected int from;
    protected int to;
    protected int every;
    protected boolean strip = true;
    protected boolean unique = true;
    protected String id = null;

    public LineageSitePatterns(Alignment alignment) {
        this(alignment, null, 0, 0, 1);
    }

    public LineageSitePatterns(Alignment alignment, TaxonList taxonList) {
        this(alignment, taxonList, 0, 0, 1);
    }

    public LineageSitePatterns(Alignment alignment, int n, int n2, int n3) {
        this(alignment, null, n, n2, n3);
    }

    public LineageSitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3) {
        this(alignment, taxonList, n, n2, n3, true);
    }

    public LineageSitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3, boolean bl) {
        this(alignment, taxonList, n, n2, n3, bl, true);
    }

    public LineageSitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3, boolean bl, boolean bl2) {
        super(LINEAGE_PATTERNS);
        if (taxonList != null) {
            SimpleAlignment simpleAlignment = new SimpleAlignment();
            for (int i = 0; i < alignment.getSequenceCount(); ++i) {
                if (taxonList.getTaxonIndex(alignment.getTaxonId(i)) == -1) continue;
                simpleAlignment.addSequence(alignment.getSequence(i));
            }
            alignment = simpleAlignment;
        }
        this.strip = bl;
        this.unique = bl2;
        this.setPatterns(alignment, n, n2, n3);
    }

    public LineageSitePatterns(SiteList siteList) {
        this(siteList, -1, -1, 1);
    }

    public LineageSitePatterns(SiteList siteList, int n, int n2, int n3) {
        super(LINEAGE_PATTERNS);
        this.setPatterns(siteList, n, n2, n3);
    }

    public SiteList getSiteList() {
        return this.siteList;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public int getEvery() {
        return this.every;
    }

    public void setFrom(int n) {
        this.setPatterns(this.getSiteList(), n, this.getTo(), this.getEvery());
    }

    public void setTo(int n) {
        this.setPatterns(this.getSiteList(), this.getFrom(), n, this.getEvery());
    }

    public void setEvery(int n) {
        this.setPatterns(this.getSiteList(), this.getFrom(), this.getTo(), n);
    }

    public void setPatterns(SiteList siteList, int n, int n2, int n3) {
        this.siteList = siteList;
        this.from = n;
        this.to = n2;
        this.every = n3;
        if (siteList == null) {
            return;
        }
        if (n <= -1) {
            n = 0;
        }
        if (n2 <= -1) {
            n2 = siteList.getSiteCount() - 1;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        this.siteCount = (n2 - n) / n3 + 1;
        this.patternCount = 0;
        this.patterns = new int[this.siteCount][];
        this.sitePatternIndices = new int[this.siteCount];
        this.weights = new double[this.siteCount];
        this.invariantCount = 0;
        int n4 = 0;
        for (int i = n; i <= n2; i += n3) {
            int[] nArray = siteList.getSitePattern(i);
            this.sitePatternIndices[n4] = !this.strip || !this.isInvariant(nArray) || !this.isGapped(nArray) && !this.isAmbiguous(nArray) && !this.isUnknown(nArray) ? this.addPattern(nArray) : -1;
            ++n4;
        }
    }

    private int addPattern(int[] nArray) {
        int n;
        for (n = 0; n < this.patternCount; ++n) {
            if (!this.unique || !this.comparePatterns(this.patterns[n], nArray)) continue;
            int n2 = n;
            this.weights[n2] = this.weights[n2] + 1.0;
            return n;
        }
        if (this.isInvariant(nArray)) {
            ++this.invariantCount;
        }
        n = this.patternCount++;
        this.patterns[n] = nArray;
        this.weights[n] = 1.0;
        return n;
    }

    private boolean isGapped(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.getDataType().isGapState(nArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isAmbiguous(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.getDataType().isAmbiguousState(nArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isUnknown(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.getDataType().isUnknownState(nArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isInvariant(int[] nArray) {
        int n = nArray.length;
        int n2 = nArray[0];
        for (int i = 1; i < n; ++i) {
            if (nArray[i] == n2) continue;
            return false;
        }
        return true;
    }

    protected boolean comparePatterns(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public int getInvariantCount() {
        return this.invariantCount;
    }

    @Override
    public int getSiteCount() {
        return this.siteCount;
    }

    @Override
    public int[] getSitePattern(int n) {
        int n2 = this.sitePatternIndices[n];
        return n2 >= 0 ? this.patterns[n2] : null;
    }

    @Override
    public double[][] getUncertainSitePattern(int n) {
        throw new UnsupportedOperationException("uncertain patterns not implemented yet");
    }

    @Override
    public int getPatternIndex(int n) {
        return this.sitePatternIndices[n];
    }

    @Override
    public int getState(int n, int n2) {
        int n3 = this.sitePatternIndices[n2];
        return n3 >= 0 ? this.patterns[n3][n] : this.getDataType().getGapState();
    }

    @Override
    public double[] getUncertainState(int n, int n2) {
        throw new UnsupportedOperationException("uncertain patterns not implemented yet");
    }

    @Override
    public int getPatternCount() {
        return this.patternCount;
    }

    @Override
    public int getStateCount() {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getStateCount();
    }

    @Override
    public int getPatternLength() {
        return this.getTaxonCount();
    }

    @Override
    public int[] getPattern(int n) {
        return this.patterns[n];
    }

    @Override
    public double[][] getUncertainPattern(int n) {
        throw new UnsupportedOperationException("uncertain patterns not implemented yet");
    }

    @Override
    public int getPatternState(int n, int n2) {
        return this.patterns[n2][n];
    }

    @Override
    public double[] getUncertainPatternState(int n, int n2) {
        throw new UnsupportedOperationException("uncertain patterns not implemented yet");
    }

    @Override
    public double getPatternWeight(int n) {
        return this.weights[n];
    }

    @Override
    public double[] getPatternWeights() {
        return this.weights;
    }

    @Override
    public DataType getDataType() {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getDataType();
    }

    @Override
    public double[] getStateFrequencies() {
        return PatternList.Utils.empiricalStateFrequencies(this);
    }

    @Override
    public boolean areUnique() {
        return this.unique;
    }

    @Override
    public boolean areUncertain() {
        return false;
    }

    @Override
    public int getTaxonCount() {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonIndex(taxon);
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < LineageSitePatterns.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return LineageSitePatterns.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonAttribute(n, string);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String toXHTML() {
        int n;
        int n2;
        String string = "<p><em>Pattern List</em>  pattern count = ";
        string = string + this.getPatternCount();
        string = string + "  invariant count = ";
        string = string + this.getInvariantCount();
        string = string + "</p>";
        string = string + "<pre>";
        int n3 = this.getDataType().getType();
        int n4 = this.getPatternCount();
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n = Integer.toString((int)this.getPatternWeight(n2)).length();
            if (n <= n5) continue;
            n5 = n;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            int n6;
            for (n6 = n = Integer.toString(n2 + 1).length(); n6 < n5; ++n6) {
                string = string + " ";
            }
            string = string + Integer.toString(n2 + 1) + ": ";
            n = Integer.toString((int)this.getPatternWeight(n2)).length();
            string = string + Integer.toString((int)this.getPatternWeight(n2));
            for (n6 = n; n6 <= n5; ++n6) {
                string = string + " ";
            }
            for (n6 = 0; n6 < this.getTaxonCount(); ++n6) {
                int n7 = this.getPatternState(n6, n2);
                string = n3 == 0 ? string + Nucleotides.INSTANCE.getChar(n7) + " " : (n3 == 2 ? string + Codons.UNIVERSAL.getTriplet(n7) + " " : string + AminoAcids.INSTANCE.getChar(n7) + " ");
            }
            string = string + "\n";
        }
        string = string + "</pre>";
        return string;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

