% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ColTypeR.R
\name{ColTypeR}
\alias{ColTypeR}
\title{Sets up column names and types}
\usage{
ColTypeR(...)
}
\arguments{
\item{...}{Additional arguments. These can be specified in addition to the ones default to the
function.  For example:
\itemize{
\item newCharacterColumn = \code{\link[readr:parse_atomic]{readr::col_character()}},
\item newNumericColumn = \code{\link[readr:parse_atomic]{readr::col_integer()}},
\item newLogicalColumn = \code{\link[readr:parse_atomic]{readr::col_logical()}}
}}
}
\value{
Returns an object of class col_spec.
See \code{\link[readr:as.col_spec]{readr::as.col_spec()}} for additional context and explication.
}
\description{
This function uses \code{\link[readr:cols]{readr::cols_only()}} to assign a column name and the type of data
(e.g., \code{\link[readr:parse_atomic]{readr::col_character()}},
and \code{\link[readr:parse_atomic]{readr::col_integer()}}). To see the default columns simply run \code{\link[=ColTypeR]{ColTypeR()}}.
This is intended for use with \code{\link[readr:read_delim]{readr::read_csv()}}. Columns that are not present will NOT be included
in the resulting tibble unless they are specified using \link{...}.
}
\examples{
  # You can simply return the below for default values
  library(dplyr)
BeeBDC::ColTypeR() 

  # To add new columns you can write
ColTypeR(newCharacterColumn = readr::col_character(), 
         newNumericColumn = readr::col_integer(), 
         newLogicalColumn = readr::col_logical()) 

# Try reading in one of the test datasets as an example:
beesFlagged \%>\% dplyr::as_tibble(col_types = BeeBDC::ColTypeR())
  # OR
beesRaw \%>\% dplyr::as_tibble(col_types = BeeBDC::ColTypeR())


}
