% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{subset_variants}
\alias{subset_variants}
\title{Remove variants with no data for pathogenicity}
\usage{
subset_variants(G, min_ac = 1L, return_variants = FALSE)
}
\arguments{
\item{G}{Integer matrix of variant counts per individual, one row per individual and one column per variant.}

\item{min_ac}{Integer vector with a length equalling the number of individuals or length \code{1} (in which case the given value is used for all individuals) giving the minimum number of alleles at pathogenic variant sites each individual requires in order to classify as having a `pathogenic allele configuration'. Thus, this parameter encodes the mode of inheritance. For instance, setting this parameter to \code{1} corresponds to dominant inheritance. If there are differences in ploidy between individuals in the locus, it is necessary to set it on an sample level basis - e.g. to ensure sex is accounted for if the locus lies on the X chromosome.}

\item{return_variants}{Logical value determining whether to return an integer vector of indices of retained variants or the subsetted allele count matrix}
}
\description{
Subset an allele count matrix given a minimum allele count threshold for pathogenicity per individual so that only variants for which data relevant to pathogencity are retained. This is useful to apply before running \code{\link{bevimed}} as it reduces the size of the parameter space used in the inference.
}
