#' A simulation dataset
#'
#'@description
#' A dataset containing simulated data that is used for examples in the package.
#' The matrix \code{mat} is generated by the following code.
#'
#' \code{seedN<-2022}
#'
#'\code{n<-200} # 200 individuals
#'
#'\code{d<-10} # 10 variables
#'
#'\code{mat<-matrix(nrow=n,ncol=d)} # the input of framework
#'
#' #Simulate binary data from Bernoulli distribution distribution where the probability of value being 1 is 0.5.
#'
#'\code{for(i in seq(n)) }
#'\code{ \{ set.seed(seedN+i) }
#'
#'\code{  mat[i,] <- rbinom(n=d, size=1, prob=0.5) \} }
#'
#'
#'\code{mat[,1]<-mat[,2] | mat[,3] } # 1 causes by 2 and 3
#'
#'\code{mat[,4] <-mat[,2] | mat[,5] }# 4 causes by 2 and 5
#'
#'\code{mat[,6] <- mat[,1] | mat[,4] } # 6 causes by 1 and 4
#'
#' @format A matrix with 200 samples and 10 dimensions generated from Bernoulli distribution.
#' \describe{
#'   \item{mat}{ It is a 200 by 10 matrix where n is a number of transactions or samples and d is a number of dimensions.}
#'     ...
#' }
"mat"

#' An example of aligned list of transactions
#'
#'@description
#' A dataset containing simulated data that is used for examples in the package.
#'
#' The \code{D} is an aligned list of transactions that was converted by using \code{D<-VecAlignment(mat)}.
#'
#' @format An aligned list of a matrix with 200 samples and 10 dimensions generated from Bernoulli distribution.
#' \describe{
#'   \item{D}{It is an aligned list of transactions that was converted from \code{mat}.}
#' }
#'
"D"

#' An example of causal inference result
#'
#'@description
#' A dataset containing a result of causal inference from simulated data that is used for examples in the package.
#'
#' @format A result of causal inference using \code{mat} as an input.
#' \describe{
#'   \item{resC}{It is a result of causal inference using simData$mat as an input by running
#'    \code{resC<-BiCausality::CausalGraphInferMainFunc(mat = mat,CausalThs=0.1, nboot =50, IndpThs=0.05)}. }.
#'    }
#'
"resC"
