% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphhelpfns.R
\name{dag2skeletonadjacency}
\alias{dag2skeletonadjacency}
\title{Deriving an adjacency matrix of the skeleton of a graph}
\usage{
dag2skeletonadjacency(g)
}
\arguments{
\item{g}{graph, object of class \code{\link[graph]{graphNEL}} (package `graph')}
}
\value{
a symmetric square matrix whose dimensions are the number of nodes in the graph \code{g},
where element \code{[i,j]} equals \code{1} if there is a directed edge from node \code{i} to node \code{j},
 or from node \code{j} to node \code{i}, in the graph \code{g}, and \code{0} otherwise
}
\description{
This function derives the skeleton matrix corresponding to a graph object
}
\examples{
myDAG<-pcalg::randomDAG(20, prob=0.15, lB = 0.4, uB = 2)
dag2skeletonadjacency(myDAG)
}
