% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MicPathmatch.R
\name{MicPathmatch}
\alias{MicPathmatch}
\title{MicPathmatch}
\usage{
MicPathmatch(microbes)
}
\arguments{
\item{microbes}{A character vector containing the names of microbes.}
}
\value{
micmatch_res A list with two data frames, one contains strains, sub-strains and affiliated pathways and the other data frame does not contain strains or sub-strains.
}
\description{
A function is used to trace the affiliation between microbes (16S or Metagenome data) and functional pathways based on Kyoto Encyclopedia of Gene and Genomes (KEGG).
You can get two tables using this function.
One is a table including predicted detail next level strains and pathways of your own microbes, the other is a table including only your own microbes and corresponding pathways.
The format of microbe is like this:
k__XXX; p__XXX; c__XXX; o__XXX; f__XXX; g__XXX; s__XXX;
k means kingdom;
p means phylum;
c means class;
o means order;
f means family;
g means genus;
s means species.
}
\examples{
MicPathmatch_res <- MicPathmatch(microbes = MicPathmatch.eg)
}
