% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigDataPE.R
\name{bdpe_fetch_data}
\alias{bdpe_fetch_data}
\title{Fetch data from the BigDataPE API}
\usage{
bdpe_fetch_data(
  base_name,
  limit = Inf,
  offset = 0,
  query = list(),
  verbosity = 0,
  endpoint = "https://www.bigdata.pe.gov.br/api/buscar"
)
}
\arguments{
\item{base_name}{A string specifying the name of the dataset associated with the token.}

\item{limit}{An integer specifying the maximum number of records to retrieve per request. Default is Inf (all records).
If set to a non-positive value or \code{Inf}, no limit will be applied.}

\item{offset}{An integer specifying the starting record for the query. Default is 0.
If set to a non-positive value or \code{Inf}, no offset will be applied.}

\item{query}{A named list of additional query parameters to filter the API results. Default is an empty list.}

\item{verbosity}{An integer specifying the verbosity level for the API requests.
Values are:
- \code{0}: No verbosity (default).
- \code{1}: Minimal verbosity, showing request status.
- \code{2}: Detailed verbosity, including request and response details.}

\item{endpoint}{A string specifying the API endpoint URL. Default is "https://www.bigdata.pe.gov.br/api/buscar".}
}
\value{
A tibble containing the data returned by the API.
}
\description{
This function retrieves data from the BigDataPE API using securely stored tokens associated with datasets.
Users can specify pagination parameters (\code{limit} and \code{offset}) and additional query filters to customize the data retrieval.
}
\examples{
\dontrun{
# Store a token for the dataset
bdpe_store_token("education_dataset", "your-token-here")

# Fetch 50 records from the beginning
data <- bdpe_fetch_data("education_dataset", limit = 50)

# Fetch records with additional query parameters
data <- bdpe_fetch_data("education_dataset", query = list(field = "value"))

# Fetch all data without limits
data <- bdpe_fetch_data("education_dataset", limit = Inf)
}
}
