% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdCreate_hdf5_matrix_file}
\alias{bdCreate_hdf5_matrix_file}
\title{Create hdf5 data file and write data to it}
\usage{
bdCreate_hdf5_matrix_file(
  filename,
  object,
  group = NULL,
  dataset = NULL,
  transp = NULL,
  force = NULL
)
}
\arguments{
\item{filename, }{character array indicating the name of the file to create}

\item{object}{numerical data matrix}

\item{group, }{character array indicating folder name to put the matrix in hdf5 file}

\item{dataset, }{character array indicating the dataset name to store the matix data}

\item{transp}{boolean, if trans=true matrix is stored transposed in hdf5 file}

\item{force, }{optional boolean if true and file exists, removes old file and creates a new file with de dataset data.}
}
\value{
none
}
\description{
Creates a hdf5 file with numerical data matrix,
}
\examples{

matA <- matrix(c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15), nrow = 3, byrow = TRUE)
bdCreate_hdf5_matrix_file("BasicMatVect.hdf5", matA, "INPUT", "matA")

# Remove file (used as example)
  if (file.exists("BasicMatVect.hdf5")) {
    # Delete file if it exist
    file.remove("BasicMatVect.hdf5")
  }

}
