% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdScalarwproduct}
\alias{bdScalarwproduct}
\title{Matrix–scalar weighted product}
\usage{
bdScalarwproduct(A, w)
}
\arguments{
\item{A}{Numeric matrix (or object convertible to a dense numeric matrix).}

\item{w}{Numeric scalar weight.}
}
\value{
A numeric matrix with the same dimensions as \code{A}.
}
\description{
Multiplies a numeric matrix \code{A} by a scalar weight \code{w},
returning \eqn{w * A}. The input must be a base R numeric matrix (or
convertible to one).
}
\examples{
set.seed(1234)
n <- 5; p <- 3
X <- matrix(rnorm(n * p), n, p)
w <- 0.75
bdScalarwproduct(X, w)

}
