% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigVARSupportFunctions.R
\name{VARXForecastEval}
\alias{VARXForecastEval}
\title{Evaluate forecasts from a VAR or VARX with lag orders selected by AIC/BIC}
\usage{
VARXForecastEval(Y, X, p, s, T1, T2, IC, h, iterated = FALSE)
}
\arguments{
\item{Y}{a \eqn{T \times k} multivariate time series}

\item{X}{a \eqn{T \times m} multivariate time series of unmodeled exogenous variables}

\item{p}{maximum lag order for endogenous series}

\item{s}{maximum lag order for exogenous series}

\item{T1}{start of forecast evaluation period.}

\item{T2}{end of forecast evaluation period}

\item{IC}{specifies whether to select lag order according to "AIC" or "BIC"}

\item{h}{desired forecast horizon}

\item{iterated}{indicator as to whether to use iterated or direct multistep forecasts (if applicable, VAR context only)}
}
\value{
Returns the one-step ahead MSFE over the evaluation period.
}
\description{
Evaluate forecasts from a VAR or VARX with lag orders selected by AIC/BIC
}
\details{
This function evaluates the one-step ahead forecasts of a VAR or VARX fit by least squares over an evaluation period.  At every point in time, lag orders for the endogenous and exogenous series are selected according to AIC or BIC.  This function is run automatically when \code{\link{cv.BigVAR}} is called unless \code{ic} is set to \code{FALSE} in \code{\link{constructModel}}.
}
\examples{
data(Y)

# Evaluate the performance of a VAR with lags selected by BIC.
p <- 4
T1 <- floor(nrow(Y))/3
T2 <- floor(2*nrow(Y))/3
# Matrix of zeros for X
X <- matrix(0,nrow=nrow(Y),ncol=ncol(Y))
BICMSFE <- VARXForecastEval(Y,X,p,0,T1,T2,"BIC",1)

}
\references{
Neumaier, Arnold, and Tapio Schneider. "Estimation of parameters and eigenmodes of multivariate autoregressive models." ACM Transactions on Mathematical Software (TOMS) 27.1 (2001): 27-57.
}
\seealso{
\code{\link{VARXFit}},\code{\link{constructModel}}, \code{\link{cv.BigVAR}}
}
